<?php

namespace App\Http\Controllers;

use App\Helpers\AppHelpers;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Inertia\Inertia;
use Illuminate\Http\Request;
use App\Models\LeadType;
use App\Models\Lead;
use App\Models\Invoice;
use App\Models\InvoiceItem;
use App\Models\User;
use App\Models\Tax;
use App\Models\Product;
use App\Models\Patron;
use App\Models\Contact;
use App\Models\Account;
use App\Models\LeadContact;
use App\Models\PatronContact;
use App\Models\EntityContact;
use App\Models\Email;
use App\Models\InvoiceTax;
use Carbon\Carbon;
use App\Models\LeadPipelineStage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Collection;
use PDF;
use Barryvdh\Snappy\Facades\SnappyPdf;
use ProtoneMedia\LaravelQueryBuilderInertiaJs\InertiaTable;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;
use App\Exports\ExportInvoice;

use Maatwebsite\Excel\Facades\Excel;
use DB;

class InvoiceController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:edit_invoices|create_invoices|delete_invoices', ['only' => ['index','store']]);
         $this->middleware('permission:create_invoices', ['only' => ['create','store']]);
         $this->middleware('permission:edit_invoices', ['only' => ['edit','update']]);
         $this->middleware('permission:delete_invoices', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        // dd($request->ip());
        if($request->customer_name!=null) $request->customer_name=$request->customer_name['legal_name'];
        $paid_status='';
        if($request->paid_status=='true')  $paid_status='1';
        if($request->paid_status=='false')  $paid_status='0';
            // dd($paid_status);
        $length = request('length', 10);
        $invoice = QueryBuilder::for(Invoice::class)
            ->join('patrons','invoices.patron_id','patrons.id')
            ->select('invoices.*','patrons.legal_name')
            ->where('invoices.entity_id',session('entity_id'))->where('invoices.deleted',0)
            ->when($request->invoice_number, function($query, $invoice_number) {
                $query->where('invoices.invoice_number', 'like', '%'.$invoice_number.'%');
            })->when($request->customer_name, function($query, $customer_name) {
                $query->where('patrons.legal_name', 'like', '%'.$customer_name.'%');
            })->when($request->from_date, function($query, $from_date) {
                $query->whereDate('invoices.invoiced_at', '>=', date($from_date));
            })->when($request->to_date, function($query, $to_date) {
                $query->whereDate('invoices.invoiced_at','<=', date($to_date));
            });
            if($paid_status!=''){
                $invoice->where('paid_status',$paid_status);
            }
            $invoice=$invoice->defaultSort('-id')
            ->allowedSorts(['id','order_number', 'prefix'])
            ->paginate($length)
            ->withQueryString();
            // dd($invoice);
        return Inertia::render('Invoice/Index', [
            'invoice' => $invoice->through(function ($invoice) {
                return [
                    'id'             => $invoice->id,
                    'prefix'         => $invoice->prefix,
                    'invoice_number' => $invoice->invoice_number,
                    'legal_name'     => $invoice->legal_name,
                    'invoiced_at'    => $invoice->invoiced_at ? changeDateFormate($invoice->invoiced_at) : null ,
                    'due_at'         => $invoice->due_at ? changeDateFormate($invoice->due_at) : null ,
                    'start_date'     => $invoice->start_date ? getMonthYear($invoice->start_date) : null ,
                    'end_date'       => $invoice->end_date ? getMonthYear($invoice->end_date) : null ,
                    'untaxed_amount' => $invoice->untaxed_amount,
                    'total_amount'   => $invoice->total_amount,
                    'paid_status'    => $invoice->paid_status,
                    'is_sent'        => $invoice->is_sent,
                ];

            }),
            'patron' => patron(),
        ])->table(function (InertiaTable $table) {
            $table->addColumns([
                'order_number'  => 'order_number',
                'prefix'        => 'prefix',
            ]);
        });
        // dd($dd);
    }
    public function Create(){

        $fincl_yr       = getFinancialYear(now());//dd($invoiceid);
        $invoiceid      = $fincl_yr[1].$fincl_yr[0];//
//        dd($invoiceid);
        $tax            = tax('', 'Sales', '', '["CGST","SGST"]');
        $patron         = patron();
        $product        = product();
        $email          = $this->email();
        // dd($invoice);
        return Inertia::render('Invoice/Create',compact('tax','product','patron','invoiceid','email'));
    }
    public function store(Request $request)
    {
        $input          = $request->all();

        $invoiceiteam   = $input['add'];
        $invoice_number = getFinancialYear($input['form']['invoiced_at']);
//        dd($invoice_number);
        Invoice::create(array(
            'entity_id'      =>  session('entity_id'),
            'patron_id'      =>  $input['form']['customer_name']['id'],
            'prefix'         =>  $input['form']['prefix'].'-'.$invoice_number[1],
            'invoice_number' =>  $invoice_number[0],
            'order_number'   =>  $input['form']['order_number'],
            'status'         =>  $input['form']['status'],
            'start_date'     =>  $input['form']['type']=='Yearly' ? $input['form']['start_date'] : $input['form']['start_date'],
            'end_date'       =>  $input['form']['type']=='Yearly' ? $input['form']['end_date'] : null,
            'invoiced_at'    =>  $input['form']['invoiced_at'],
            'due_at'         =>  $input['form']['due_at'],
            'untaxed_amount' =>  $input['form']['untaxed_amount'],
            'tax_amount'     =>  $input['form']['tax_amount'],
            'total_amount'   =>  $input['form']['total_amount'],
            'discount_amount'=>  $input['form']['discount_amount'],
            'notes'          =>  $input['form']['notes'],
            'type'           =>  $input['form']['type'],
            'created'        =>  now(),
            'created_by'     =>  Auth::user()->id
        ));

        $invoiceid  = Invoice::where('entity_id',session('entity_id'))->where('deleted','0')->latest()->first();

        foreach ($invoiceiteam as $value) {
            $invoiceitm = new InvoiceItem;
            if($value['price']!=null && $value['quantity']!=null){
                $invoiceitm->entity_id          .= session('entity_id');
                $invoiceitm->invoice_id         .= $invoiceid['id'];
                $invoiceitm->product_id         .= $value['product_id']['id'];
                $invoiceitm->description        .= $value['description'];
                $invoiceitm->quantity           .= $value['quantity'];
                $invoiceitm->price              .= $value['price'];
                $invoiceitm->discount_type      .= $value['discount_type'];
                $invoiceitm->discount_amount    .= $value['discount_amount'];
                if($value['tax_id']!=null)$invoiceitm->tax_id .= $value['tax_id']['id'];
                    else $invoiceitm->tax_id = null;
                $invoiceitm->tax_amount         .= $value['tax_amount'];
                $invoiceitm->total_amount       .= $value['total_amount'];
                $invoiceitm->created            .= now();
                $invoiceitm->created_by         .= Auth::user()->id;
                $invoiceitm->save();
            }
//            dd($value['tax_id']);
            if($value['tax_id']!=null) {
                $tax     = taxes('','',$value['tax_id']['id'],'');
//                dd($tax);
                foreach($tax as $val){
                        $amount  = (($value['total_amount'] * ($val['tax_amount']/100)));
                        $taxname = $val['tax_group'].' '.$val['tax_amount'].'%';
//                         dd($taxname);
                    $invoicetax  = new InvoiceTax;
                    $invoicetax->entity_id      .= session('entity_id');
                        $invoicetax->invoice_id .= $invoiceid['id'];
                        $invoicetax->tax_id     .= $val['id'];
                        $invoicetax->name       .= $taxname;
                        $invoicetax->amount     .= $amount;
                        $invoicetax->created    .= now();
                        $invoicetax->created_by .= Auth::user()->id;
                        $invoicetax->save();
                }
            }
        }
        // dd($value);
        return Redirect::route('invoice');
    }
    public function edit($id)
    {
        $invoice=InvoiceItem::join('invoices','invoice_items.invoice_id','invoices.id')
                            ->join('products','invoice_items.product_id','products.id')
                            ->join('patrons','invoices.patron_id','patrons.id')
                            ->where('invoices.id',$id)
                            ->where('invoice_items.deleted','0')
                            ->select('invoices.patron_id','invoices.prefix','invoices.invoice_number','invoices.id as i_id','invoices.is_sent',
                            'invoices.order_number','invoices.status','invoices.start_date','invoices.end_date','invoices.invoiced_at',
                            'invoices.due_at','invoices.untaxed_amount','invoices.tax_amount as i_taxamt','invoices.total_amount as i_totamt',
                            'invoices.discount_amount as i_disamt','invoices.paid_status',
                            'invoices.notes','invoices.type','invoice_items.id as it_id',
                            'invoice_items.product_id','invoice_items.total_amount as it_totamt',
                            'invoice_items.tax_amount as it_taxamt',
                            'invoice_items.description','invoice_items.quantity',
                            'invoice_items.price','invoice_items.discount_type',
                            'invoice_items.discount_amount as it_disamt',
                            'invoice_items.tax_id','patrons.*','products.name')->get();
        //for select json data send to fetch
        $email      = $this->email();
        foreach ($invoice as $key => $val) {
            // dd($val);
            if($val['discount_type']=="%") $total_discount  = ($val['it_totamt'] * ($val['it_disamt']/100));
                else $total_discount  = $val['it_disamt'];
            $product=Product::where('id',$val['product_id'])->where('deleted','0')->select('id','name','sale_price','tax_id')->get()->toArray();
            if($val['tax_id']!=null){
                $tax=Tax::where('id',$val['tax_id'])->where('deleted','0')->select('id','tax_name','tax_type','tax_amount')->get()->toArray();
                $taxes=$tax[0];
            }else{
                $taxes='';
            }
            $invoiceiteam[]=['id'           => $val['it_id'],
                            'product_id'    => $product[0],
                            'it_totamt'     => $val['it_totamt'],
                            'it_taxamt'     => $val['it_taxamt'],
                            'description'   => $val['description'],
                            'quantity'      => $val['quantity'],
                            'price'         => $val['price'],
                            'discount_type' => $val['discount_type'],
                            'it_disamt'     => $val['it_disamt'],
                            'tax_id'        => $taxes,
                            'total_discount'=> $total_discount,
                            'readonly'      => true,
                            'disabled'      => true,
                        ];
        }
        //select value get and patron id select get
        $tax        = tax('', 'Sales', '', '');
        $patron     = patron();
        $product    = product();
        $patronid   = patronid($invoice[0]['patron_id']);
        $invoicedata= Invoice::where('entity_id',session('entity_id'))->where('deleted', 0)->get('id');
        $account    = Account::where('invoice_id',$id)->where('entity_id',session('entity_id'))->where('deleted', 0)->get();
        if(count($account) > 0) $paiddate  = $account[0]['paid_date'];
            else $paiddate  = null;
        // dd( $paiddate);
        return Inertia::render('Invoice/Edit',compact('invoice','invoiceiteam','tax','product','patron','patronid','invoicedata','email','paiddate'));
    }
    public function update(Request $request)
    {
        $input        = $request->all();
        $invoiceiteam = $input['add'];
        // dd($input);
        // $validate =  $this->validateinvoice();
        Invoice::findOrFail($input['form']['id'])->update(array(
                    'entity_id'     => session('entity_id'),
                    'patron_id'     => $input['form']['customer_name']['id'],
                    'prefix'        => $input['form']['prefix'],
                    'invoice_number'=> $input['form']['invoice_number'],
                    'order_number'  => $input['form']['order_number'],
                    'status'        => $input['form']['status'],
                    'start_date'    => $input['form']['type']=='Yearly' ? $input['form']['start_date'] : $input['form']['start_date'],
                    'end_date'      => $input['form']['type']=='Yearly' ? $input['form']['end_date'] : null,
                    'invoiced_at'   => $input['form']['invoiced_at'],
                    'due_at'        => $input['form']['due_at'],
                    'untaxed_amount'=> $input['form']['untaxed_amount'],
                    'tax_amount'    => $input['form']['i_taxamt'],
                    'total_amount'  => $input['form']['i_totamt'],
                    'discount_amount'=>$input['form']['i_disamt'],
                    'notes'         => $input['form']['notes'],
                    'type'          => $input['form']['type'],
                    'modified'      => now(),
                    'modified_by'   => Auth::user()->id
                ));

        // delete
        if($input['itemdelete']!=[]){
            foreach($input['itemdelete'] as $value){
                $tax     = tax('','',$value['tax_id'],'');
                InvoiceItem::where('id', $value['id'])->update(array('deleted'=>'1'));
                foreach($tax as $val){
                    // dd($val['id'],$input['form']['id'],session('entity_id'));
                    DB::table('invoice_tax')
                    ->where('tax_id',$val['id'])->where('invoice_id',$input['form']['id'])->where('entity_id',session('entity_id'))
                    ->update(array('deleted'=>'1'));
                }
            }
        }
        //invoiceiteam create and update
        foreach ($invoiceiteam as $value) {
            $record = InvoiceItem::where('id',$value['id'])->first();
            // dd($value);
            if ($record==null) {
                    if($value['price']!=null && $value['quantity']!=null){
                        $invoiceitm = new InvoiceItem;
                        $invoiceitm->entity_id      .= session('entity_id'); //dd($invoiceitm->entity_id);
                        $invoiceitm->invoice_id     .= $input['form']['id']; //dd($invoiceitm->invoice_id);
                        $invoiceitm->product_id     .= $value['product_id']['id'];//dd($invoiceitm->product_id);
                        $invoiceitm->description    .= $value['description'];//dd($invoiceitm->description);
                        $invoiceitm->quantity       .= $value['quantity'];//dd($invoiceitm->quantity);
                        $invoiceitm->price          .= $value['price'];//dd($invoiceitm->price);
                        $invoiceitm->discount_type  .= $value['discount_type'];//dd($invoiceitm->discount_type);
                        $invoiceitm->discount_amount.= $value['it_disamt'];//dd($invoiceitm->discount_amount);
                        if($value['tax_id']!=null)$invoiceitm->tax_id .= $value['tax_id']['id'];//dd($invoiceitm->tax_id);
                            else $invoiceitm->tax_id = null;
                        $invoiceitm->tax_amount     .= $value['it_taxamt'];//dd($invoiceitm->tax_amount);
                        $invoiceitm->total_amount   .= $value['it_totamt'];//dd($invoiceitm->tax_amount);
                        $invoiceitm->created        .= now();//dd($invoiceitm->created);
                        $invoiceitm->created_by     .= Auth::user()->id;//dd($invoiceitm->created_by);
                        $invoiceitm->save();

                        if($value['tax_id']!=null) {
                            $tax     = taxes('','',$value['tax_id'],'');
                            foreach($tax as $val){
                                    $amount  = (($value['it_totamt'] * ($val['tax_amount']/100)));
                                    $taxname = $val['tax_group'].' '.$val['tax_amount'].'%';
                            $invoicetax = new InvoiceTax;
                            $invoicetax->entity_id  .= session('entity_id');
                            $invoicetax->invoice_id .= $input['form']['id'];
                            $invoicetax->tax_id     .= $val['id'];
                            $invoicetax->name       .= $taxname;
                            $invoicetax->amount     .= $amount;
                            $invoicetax->created    .= now();
                            $invoicetax->created_by .= Auth::user()->id;
                            $invoicetax->save();
                            }
                        }
                    }
            }else{
                if($value['tax_id']==null)$value['tax_id'] = null;//dd($invoiceitm->tax_id);
                        else $value['tax_id'] = $value['tax_id']['id'];
                InvoiceItem::where('id', $value['id'])->update(array(
                    'entity_id'     => session('entity_id'),
                    'invoice_id'    => $input['form']['id'],
                    'product_id'    => $value['product_id']['id'],
                    'description'   => $value['description'],
                    'quantity'      => $value['quantity'],
                    'price'         => $value['price'],
                    'discount_type' => $value['discount_type'],
                    'discount_amount'=> $value['it_disamt'],
                    'tax_id'        => $value['tax_id'],
                    'tax_amount'    => $value['it_taxamt'],
                    'total_amount'  => $value['it_totamt'],
                    'modified'      => now(),
                    'modified_by'   => Auth::user()->id,
                ));

                if($value['tax_id']!=null) {
                    $tax     = taxes('','',$value['tax_id'],'');
                    foreach($tax as $val){
                        $amount  = (($value['it_totamt'] * ($val['tax_amount']/100)));
                        $taxname = $val['tax_group'].' '.$val['tax_amount'].'%';
                        // dd($val['id']);
                        InvoiceTax::where('tax_id',$val['id'])->where('invoice_id',$input['form']['id'])->where('entity_id',session('entity_id'))
                            ->update(array(
                            'name'          => $taxname,
                            'amount'        => $amount,
                            'modified'      => now(),
                            'modified_by'   => Auth::user()->id,
                        ));
                    }
                }
            }
        }
        return Redirect::route('invoice');
    }
    public function invoicePdf($id)
    {
        $invoice        = $this->invoice($id);
        $invoiceitem    = $this->invoiceiteam($id);
        $toAddress      = $this->toAddress($id);
        $fromAddress    = $this->fromAddress($id);
        $email          = $this->email();
        $fileName       = $toAddress[0]['legal_name'];
        $invoicetax     = InvoiceTax::where('invoice_id',$id)->where('deleted',0)
                            ->selectRaw("name")->selectRaw("SUM(amount) as amount")
                            ->groupBy('name')->get();
        // dd($invoice,$invoiceitem);
         return view('invoice',compact('invoice', 'toAddress', 'fromAddress', 'invoiceitem','email','invoicetax'));
        // <img src='https://fermi.modocrm.com/public/assets/modo_v3.jpg' width=100 height=20 style='margin-top:10px; margin-left:5px'>
        $pdf1= SnappyPdf::setOption('footer-html' ,"<footer style='text-align:center; color:#969BA7; border-top:1px solid #D8DADF'>  	&#169; Powered By <img src='https://fermi.modocrm.com/public/assets/modo_v3.jpg' width=100 height=20 style='margin-top:10px; margin-left:5px'></footer>")
        ->setOption('footer-font-size', 10)->setOption('margin-bottom', 10)->loadView('invoice',compact('invoice', 'toAddress', 'fromAddress', 'invoiceitem','email','invoicetax'));
        // dd($invoiceitem);
        return $pdf1->download($fileName.'.pdf');
    }
    public function destroy($id)
    {
        Invoice::findOrFail($id)->update(array('deleted'=>'1'));
        InvoiceItem::where('invoice_id', $id)
        ->update([
            'deleted' => 1
        ]);
        return Redirect::route('invoice')->with('success', 'Invoice Deleted.');
    }
    // public function paidstatus($id)
    // {
    //     Invoice::findOrFail($id)->update(array('paid_status'=>'1'));

    //     // Account::

    //     return Redirect::route('invoice')->with('success', 'Successfully Paid .');
    // }
    public function paidstatus(Request $request,$id)
    {

        Invoice::where('id',$id)->where('entity_id',session('entity_id'))->where('deleted',0)->update(array('paid_status'=>'1'));
        $invoice=Invoice::where('id',$id)->where('entity_id',session('entity_id'))->where('deleted',0)->latest()->first();
//        dd($invoice);
        Account::create(array(
            'invoice_id'     =>  $invoice['id'],
            'patron_id'      =>  $invoice['patron_id'],
            'paid_date'      =>  AppHelpers::instance()->getFormattedDate(now()),
            'untaxed_amount' =>  $invoice['untaxed_amount'],
            'total_amount'   =>  $invoice['total_amount'],
            'entity_id'      =>  session('entity_id'),
            'created'        =>  now(),
            'created_by'     =>  Auth::user()->id,
        ));

        return Redirect::route('invoice')->with('success', 'Successfully Paid.');
    }
    public function rowdelete($row)
    {
        // dd($row);
        $rowdelete =InvoiceItem::findOrFail($row)->update(array('deleted'=>'1'));
        return $rowdelete;
    }
    public function invoicemail($id){

        $invoice        = $this->invoice($id);
        $invoiceitem    = $this->invoiceiteam($id);
        $toAddress      = $this->toAddress($id);
        $fromAddress    = $this->fromAddress($id);
        $email          = $this->email();
        $invoicetax     = InvoiceTax::where('invoice_id',$id)->where('deleted',0)
                            ->selectRaw("name")->selectRaw("SUM(amount) as amount")
                            ->groupBy('name')->get();
        Invoice::findOrFail($id)->update(array('is_sent'=>'1'));
        // return view('emails.mail',compact('invoice','invoiceitem','toAddress','fromAddress','email','invoicetax'));
        $pdf = Pdf::loadView('invoice',compact('invoice','invoiceitem','toAddress','fromAddress','email','invoicetax'));

       \Mail::to($toAddress[0]->email)->send(new \App\Mail\InvoiceMail($invoice,$invoiceitem,$toAddress,$fromAddress,$pdf,$email));
        if (\Mail::failures()) {
              return response()->Fail('Sorry! Please try again latter');
        }else{
              return Redirect::route('invoice')->with('success', 'Successfully .');
        }
    }
    protected function invoiceiteam($id)
    {
        $invoiceitems   = InvoiceItem::join('invoices', 'invoice_items.invoice_id', 'invoices.id')
                        ->join('products', 'invoice_items.product_id', 'products.id')
                        ->where('invoice_items.invoice_id', '=', $id)->where('invoice_items.deleted',0)
                        ->get(['products.name','products.code', 'invoice_items.quantity','invoice_items.tax_amount','invoice_items.tax_id',
                        'invoice_items.price', 'invoice_items.total_amount', 'invoice_items.description']);

        foreach ($invoiceitems as $key => $val) {
            // dd($val);
            if($val['tax_id']!=null){
                $tax        = Tax::where('id',$val['tax_id'])->where('deleted','0')->where('entity_id',session('entity_id'))->select('id','tax_name','tax_type','tax_amount')->get()->toArray();
                $taxes      = $tax[0]['tax_amount'];
                $taxeid     = $tax[0]['id'];
                $tax_name=$tax[0]['tax_name'];
            }else{
                $taxes      = '0';
                $taxeid     = '';
                $tax_name='';
            }
            $invoiceitem[]=['name'      => $val['name'],
                            'code'      => $val['code'] ? $val['code'] : '-',
                            'quantity'  => $val['quantity'],
                            'tax_amount'=> $val['tax_amount'],
                            'tax_id'    => $taxes,
                            'tax_name'  => $tax_name,
                            'price'     => $val['price'],
                            'total_amount'=> $val['total_amount'],
                            'description' => $val['description'],
                            'taxeid'    => $taxeid,
                        ];
        }
        // dd($invoiceitem);
        return $invoiceitem;
    }
    protected function invoice($id)
    {
        $invoice=Invoice::join('patrons','invoices.patron_id','patrons.id')
                    ->where('invoices.id', '=', $id)->get([ 'invoices.invoice_number', 'invoices.prefix', 'invoices.untaxed_amount',
                    'invoices.discount_amount','invoices.tax_amount as invoiceTaxAmount','invoices.total_amount as invoice_totalamount',
                    'invoices.start_date','invoices.end_date', 'invoices.notes', 'invoices.notes','invoices.type', 'invoices.untaxed_amount',
                    'invoices.invoiced_at','invoices.due_at','patrons.legal_name']);

        return $invoice;
    }
    protected function toAddress($id)
    {
        $toAddress=PatronContact::join('invoices', 'invoices.patron_id', '=', 'patron_contacts.patron_id')
                    ->join('patrons', 'patrons.id', '=', 'patron_contacts.patron_id')
                    ->join('contacts', 'contacts.id', '=', 'patron_contacts.contact_id')
                    ->where('invoices.id', '=', $id)
                    ->get(['patrons.legal_name', 'contacts.line_1','contacts.line_2','patrons.gstin',  'contacts.zipcode', 'contacts.state_name', 'contacts.city', 'contacts.email', 'contacts.mobile'])
                    ->take(1);

        return $toAddress;
    }
    protected function fromAddress($id)
    {
        $fromAddress=EntityContact::join('invoices', 'invoices.entity_id', '=', 'entity_contacts.entity_id')
                    ->join('entities', 'invoices.entity_id', '=', 'entities.id')
                    ->join('contacts', 'contacts.id', '=', 'entity_contacts.contact_id')
                    ->where('invoices.id', '=', $id)
                    ->get(['entities.legal_name', 'entities.logo_file', 'contacts.line_1', 'contacts.line_2','entities.gstin', 'contacts.zipcode', 'contacts.state_name', 'contacts.city', 'contacts.email', 'contacts.mobile'])
                    ->take(1);
        return $fromAddress;
    }
    protected function email()
    {
        $email=Email::where('entity_id',session('entity_id'))->get();
        return $email;
    }
    public function invoiceexport(Request $request)
    {
//        dd($request->all());
        if($request->customer_name!=null) $request->customer_name=$request->customer_name['legal_name'];
        $paid_status='';
        if($request->paid_status=='1')   $paid_status='1';
        if($request->paid_status=='0')  $paid_status='0';

//dd($paid_status);
        $invoiceitems   = InvoiceItem::join('invoices', 'invoice_items.invoice_id', 'invoices.id')
                        ->join('patrons', 'invoices.patron_id', 'patrons.id')
                        ->join('products', 'invoice_items.product_id', 'products.id')
                        ->where('invoice_items.deleted',0)
                        ->where('invoice_items.entity_id',session('entity_id'))
                        ->when($request->invoice_number, function($query, $invoice_number) {
                            $query->where('invoices.invoice_number', 'like', '%'.$invoice_number.'%');
                        })->when($paid_status, function($query, $paid_status) {
                            $query->where('invoices.paid_status', $paid_status);
                        })->when($request->from_date, function($query, $from_date) {
                            $query->whereDate('invoices.invoiced_at', '>=', date($from_date));
                        })->when($request->to_date, function($query, $to_date) {
                            $query->whereDate('invoices.invoiced_at','<=', date($to_date));
                        });

        $data =$invoiceitems->get(['products.name as product','products.code', 'invoice_items.quantity','invoice_items.tax_amount','invoice_items.tax_id',
                        'invoice_items.price', 'invoice_items.total_amount as linetotalamount', 'invoice_items.description', 'invoices.invoice_number','invoices.prefix','invoices.invoiced_at',
                        'invoices.due_at','invoices.total_amount as grand_total', 'invoices.start_date','invoices.end_date', 'patrons.legal_name', 'patrons.gstin']);

//        dd($data);

        return Excel::download(new ExportInvoice($data), 'Invoice.xlsx');
    }
    public function invoicenumber($date){
        $mydate     = new Carbon($date);
        $date_year  = $mydate->format('Y');
        $invoicevalue   = Invoice::where('entity_id',session('entity_id'))
                            ->whereYear('invoiced_at',$date_year)->where('deleted', 0)->latest()->first();
        $inv_id         = $invoicevalue ? $invoicevalue['invoice_number']+1 : 1;
        return  $inv_id;
    }

    public function BulkInvoiceMail()
    {

        $patron=Patron::join('patron_contacts', 'patrons.id', '=', 'patron_contacts.patron_id')
            ->join('contacts', 'patron_contacts.contact_id', '=', 'contacts.id')
            ->where('patrons.entity_id',session('entity_id'))->where('patrons.deleted', 0)->get();
//        dd($patron);
//        whereMonth('creation_date', Carbon::now()->month)->
        foreach($patron as $item=>$value) {
//            dd($value);
//
            if($value['email']!=null) {

                $date=new \DateTime(now());
                $currentMonth =  $date->format('m');
                $currentYear  =  $date->format('Y');
//                dd($currentMonthYear);
            $getinvoice=Invoice::whereMonth('start_date', $currentMonth)->whereYear('start_date', $currentYear)
                ->where('entity_id',session('entity_id'))->where('deleted', 0)->get();
//                dd($getinvoice);
                foreach($getinvoice as $key1=>$value1) {
//                    dd($value1);
                    if($value1['is_sent']==0) {
//                        dd($value1);
                        $id = $value1['id'];
                        $invoice = $this->invoice($id);
                        $invoiceitem = $this->invoiceiteam($id);
                        $toAddress = $this->toAddress($id);
                        $fromAddress = $this->fromAddress($id);
                        $email = $this->email();
                        $invoicetax = InvoiceTax::where('invoice_id', $id)->where('deleted', 0)
                            ->selectRaw("name")->selectRaw("SUM(amount) as amount")
                            ->groupBy('name')->get();

//                        dd($toAddress[0]->email);
                        // return view('e`mail`s.mail',compact('invoice','invoiceitem','toAddress','fromAddress','email','invoicetax'));
                        $pdf = Pdf::loadView('invoice', compact('invoice', 'invoiceitem', 'toAddress', 'fromAddress', 'email', 'invoicetax'));

                        \Mail::to($toAddress[0]->email)->send(new \App\Mail\InvoiceMail($invoice, $invoiceitem, $toAddress, $fromAddress, $pdf, $email));
//                        dd($toAddress[0]->email);
                        Invoice::findOrFail($id)->update(array('is_sent' => '1'));
                        if (\Mail::failures()) {
                            dd('failures');
                            return response()->Fail('Sorry! Please try again latter');
                        } else {
                            dd('sa');
                            return Redirect::route('invoice')->with('success', 'Successfully .');
                        }
                    }else{
                        dd("com");
                        return Redirect::route('invoice')->with('success', 'Successfully .');
                    }
                }
            }
        }
    }

}
