var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Combobox: () => Combobox,
  ComboboxButton: () => ComboboxButton,
  ComboboxInput: () => ComboboxInput,
  ComboboxLabel: () => ComboboxLabel,
  ComboboxOption: () => ComboboxOption,
  ComboboxOptions: () => ComboboxOptions,
  Dialog: () => Dialog,
  DialogDescription: () => DialogDescription,
  DialogOverlay: () => DialogOverlay,
  DialogTitle: () => DialogTitle,
  Disclosure: () => Disclosure,
  DisclosureButton: () => DisclosureButton,
  DisclosurePanel: () => DisclosurePanel,
  FocusTrap: () => FocusTrap,
  Listbox: () => Listbox,
  ListboxButton: () => ListboxButton,
  ListboxLabel: () => ListboxLabel,
  ListboxOption: () => ListboxOption,
  ListboxOptions: () => ListboxOptions,
  Menu: () => Menu,
  MenuButton: () => MenuButton,
  MenuItem: () => MenuItem,
  MenuItems: () => MenuItems,
  Popover: () => Popover,
  PopoverButton: () => PopoverButton,
  PopoverGroup: () => PopoverGroup,
  PopoverOverlay: () => PopoverOverlay,
  PopoverPanel: () => PopoverPanel,
  Portal: () => Portal,
  PortalGroup: () => PortalGroup,
  RadioGroup: () => RadioGroup,
  RadioGroupDescription: () => RadioGroupDescription,
  RadioGroupLabel: () => RadioGroupLabel,
  RadioGroupOption: () => RadioGroupOption,
  Switch: () => Switch,
  SwitchDescription: () => SwitchDescription,
  SwitchGroup: () => SwitchGroup,
  SwitchLabel: () => SwitchLabel,
  Tab: () => Tab,
  TabGroup: () => TabGroup,
  TabList: () => TabList,
  TabPanel: () => TabPanel,
  TabPanels: () => TabPanels,
  TransitionChild: () => TransitionChild,
  TransitionRoot: () => TransitionRoot
});

// src/components/combobox/combobox.ts
var import_vue6 = require("vue");

// src/utils/render.ts
var import_vue = require("vue");

// src/utils/match.ts
function match(value, lookup, ...args) {
  if (value in lookup) {
    let returnValue = lookup[value];
    return typeof returnValue === "function" ? returnValue(...args) : returnValue;
  }
  let error = new Error(`Tried to handle "${value}" but there is no handler defined. Only defined handlers are: ${Object.keys(lookup).map((key) => `"${key}"`).join(", ")}.`);
  if (Error.captureStackTrace)
    Error.captureStackTrace(error, match);
  throw error;
}

// src/utils/render.ts
function render({
  visible = true,
  features = 0 /* None */,
  ...main
}) {
  var _a;
  if (visible)
    return _render(main);
  if (features & 2 /* Static */) {
    if (main.props.static)
      return _render(main);
  }
  if (features & 1 /* RenderStrategy */) {
    let strategy = ((_a = main.props.unmount) != null ? _a : true) ? 0 /* Unmount */ : 1 /* Hidden */;
    return match(strategy, {
      [0 /* Unmount */]() {
        return null;
      },
      [1 /* Hidden */]() {
        return _render({
          ...main,
          props: { ...main.props, hidden: true, style: { display: "none" } }
        });
      }
    });
  }
  return _render(main);
}
function _render({
  props,
  attrs,
  slots,
  slot,
  name
}) {
  var _a;
  let { as, ...passThroughProps } = omit(props, ["unmount", "static"]);
  let children = (_a = slots.default) == null ? void 0 : _a.call(slots, slot);
  if (as === "template") {
    if (Object.keys(passThroughProps).length > 0 || Object.keys(attrs).length > 0) {
      let [firstChild, ...other] = children != null ? children : [];
      if (!isValidElement(firstChild) || other.length > 0) {
        throw new Error([
          'Passing props on "template"!',
          "",
          `The current component <${name} /> is rendering a "template".`,
          `However we need to passthrough the following props:`,
          Object.keys(passThroughProps).concat(Object.keys(attrs)).map((line) => `  - ${line}`).join("\n"),
          "",
          "You can apply a few solutions:",
          [
            'Add an `as="..."` prop, to ensure that we render an actual element instead of a "template".',
            "Render a single element as the child so that we can forward the props onto that element."
          ].map((line) => `  - ${line}`).join("\n")
        ].join("\n"));
      }
      return (0, import_vue.cloneVNode)(firstChild, passThroughProps);
    }
    if (Array.isArray(children) && children.length === 1) {
      return children[0];
    }
    return children;
  }
  return (0, import_vue.h)(as, passThroughProps, children);
}
function omit(object, keysToOmit = []) {
  let clone = Object.assign({}, object);
  for (let key of keysToOmit) {
    if (key in clone)
      delete clone[key];
  }
  return clone;
}
function isValidElement(input) {
  if (input == null)
    return false;
  if (typeof input.type === "string")
    return true;
  if (typeof input.type === "object")
    return true;
  if (typeof input.type === "function")
    return true;
  return false;
}

// src/hooks/use-id.ts
var id = 0;
function generateId() {
  return ++id;
}
function useId() {
  return generateId();
}

// src/utils/calculate-active-index.ts
function assertNever(x) {
  throw new Error("Unexpected object: " + x);
}
function calculateActiveIndex(action, resolvers) {
  let items = resolvers.resolveItems();
  if (items.length <= 0)
    return null;
  let currentActiveIndex = resolvers.resolveActiveIndex();
  let activeIndex = currentActiveIndex != null ? currentActiveIndex : -1;
  let nextActiveIndex = (() => {
    switch (action.focus) {
      case 0 /* First */:
        return items.findIndex((item) => !resolvers.resolveDisabled(item));
      case 1 /* Previous */: {
        let idx = items.slice().reverse().findIndex((item, idx2, all) => {
          if (activeIndex !== -1 && all.length - idx2 - 1 >= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
        if (idx === -1)
          return idx;
        return items.length - 1 - idx;
      }
      case 2 /* Next */:
        return items.findIndex((item, idx) => {
          if (idx <= activeIndex)
            return false;
          return !resolvers.resolveDisabled(item);
        });
      case 3 /* Last */: {
        let idx = items.slice().reverse().findIndex((item) => !resolvers.resolveDisabled(item));
        if (idx === -1)
          return idx;
        return items.length - 1 - idx;
      }
      case 4 /* Specific */:
        return items.findIndex((item) => resolvers.resolveId(item) === action.id);
      case 5 /* Nothing */:
        return null;
      default:
        assertNever(action);
    }
  })();
  return nextActiveIndex === -1 ? currentActiveIndex : nextActiveIndex;
}

// src/utils/dom.ts
function dom(ref18) {
  if (ref18 == null)
    return null;
  if (ref18.value == null)
    return null;
  return "$el" in ref18.value ? ref18.value.$el : ref18.value;
}

// src/hooks/use-window-event.ts
var import_vue2 = require("vue");
function useWindowEvent(type, listener, options) {
  if (typeof window === "undefined")
    return;
  (0, import_vue2.watchEffect)((onInvalidate) => {
    window.addEventListener(type, listener, options);
    onInvalidate(() => {
      window.removeEventListener(type, listener, options);
    });
  });
}

// src/internal/open-closed.ts
var import_vue3 = require("vue");
var Context = Symbol("Context");
function hasOpenClosed() {
  return useOpenClosed() !== null;
}
function useOpenClosed() {
  return (0, import_vue3.inject)(Context, null);
}
function useOpenClosedProvider(value) {
  (0, import_vue3.provide)(Context, value);
}

// src/hooks/use-resolve-button-type.ts
var import_vue4 = require("vue");
function resolveType(type, as) {
  if (type)
    return type;
  let tag = as != null ? as : "button";
  if (typeof tag === "string" && tag.toLowerCase() === "button")
    return "button";
  return void 0;
}
function useResolveButtonType(data, refElement) {
  let type = (0, import_vue4.ref)(resolveType(data.value.type, data.value.as));
  (0, import_vue4.onMounted)(() => {
    type.value = resolveType(data.value.type, data.value.as);
  });
  (0, import_vue4.watchEffect)(() => {
    var _a;
    if (type.value)
      return;
    if (!dom(refElement))
      return;
    if (dom(refElement) instanceof HTMLButtonElement && !((_a = dom(refElement)) == null ? void 0 : _a.hasAttribute("type"))) {
      type.value = "button";
    }
  });
  return type;
}

// src/hooks/use-tree-walker.ts
var import_vue5 = require("vue");
function useTreeWalker({
  container,
  accept,
  walk,
  enabled
}) {
  (0, import_vue5.watchEffect)(() => {
    let root = container.value;
    if (!root)
      return;
    if (enabled !== void 0 && !enabled.value)
      return;
    let acceptNode = Object.assign((node) => accept(node), { acceptNode: accept });
    let walker = document.createTreeWalker(root, NodeFilter.SHOW_ELEMENT, acceptNode, false);
    while (walker.nextNode())
      walk(walker.currentNode);
  });
}

// src/components/combobox/combobox.ts
var ComboboxContext = Symbol("ComboboxContext");
function useComboboxContext(component) {
  let context = (0, import_vue6.inject)(ComboboxContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <Combobox /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useComboboxContext);
    throw err;
  }
  return context;
}
var Combobox = (0, import_vue6.defineComponent)({
  name: "Combobox",
  emits: { "update:modelValue": (_value) => true },
  props: {
    as: { type: [Object, String], default: "template" },
    disabled: { type: [Boolean], default: false },
    modelValue: { type: [Object, String, Number, Boolean] }
  },
  setup(props, { slots, attrs, emit }) {
    let comboboxState = (0, import_vue6.ref)(1 /* Closed */);
    let labelRef = (0, import_vue6.ref)(null);
    let inputRef = (0, import_vue6.ref)(null);
    let buttonRef = (0, import_vue6.ref)(null);
    let optionsRef = (0, import_vue6.ref)(null);
    let optionsPropsRef = (0, import_vue6.ref)({
      static: false,
      hold: false
    });
    let options = (0, import_vue6.ref)([]);
    let activeOptionIndex = (0, import_vue6.ref)(null);
    let value = (0, import_vue6.computed)(() => props.modelValue);
    let api = {
      comboboxState,
      value,
      inputRef,
      labelRef,
      buttonRef,
      optionsRef,
      disabled: (0, import_vue6.computed)(() => props.disabled),
      options,
      activeOptionIndex,
      inputPropsRef: (0, import_vue6.ref)({ displayValue: void 0 }),
      optionsPropsRef,
      closeCombobox() {
        if (props.disabled)
          return;
        if (comboboxState.value === 1 /* Closed */)
          return;
        comboboxState.value = 1 /* Closed */;
        activeOptionIndex.value = null;
      },
      openCombobox() {
        if (props.disabled)
          return;
        if (comboboxState.value === 0 /* Open */)
          return;
        comboboxState.value = 0 /* Open */;
      },
      goToOption(focus, id2) {
        if (props.disabled)
          return;
        if (optionsRef.value && !optionsPropsRef.value.static && comboboxState.value === 1 /* Closed */)
          return;
        let nextActiveOptionIndex = calculateActiveIndex(focus === 4 /* Specific */ ? { focus: 4 /* Specific */, id: id2 } : { focus }, {
          resolveItems: () => options.value,
          resolveActiveIndex: () => activeOptionIndex.value,
          resolveId: (option) => option.id,
          resolveDisabled: (option) => option.dataRef.disabled
        });
        if (activeOptionIndex.value === nextActiveOptionIndex)
          return;
        activeOptionIndex.value = nextActiveOptionIndex;
      },
      syncInputValue() {
        let value2 = api.value.value;
        if (!dom(api.inputRef))
          return;
        if (value2 === void 0)
          return;
        let displayValue = api.inputPropsRef.value.displayValue;
        if (typeof displayValue === "function") {
          api.inputRef.value.value = displayValue(value2);
        } else if (typeof value2 === "string") {
          api.inputRef.value.value = value2;
        }
      },
      selectOption(id2) {
        let option = options.value.find((item) => item.id === id2);
        if (!option)
          return;
        let { dataRef } = option;
        emit("update:modelValue", dataRef.value);
        api.syncInputValue();
      },
      selectActiveOption() {
        if (activeOptionIndex.value === null)
          return;
        let { dataRef } = options.value[activeOptionIndex.value];
        emit("update:modelValue", dataRef.value);
        api.syncInputValue();
      },
      registerOption(id2, dataRef) {
        var _a, _b;
        let currentActiveOption = activeOptionIndex.value !== null ? options.value[activeOptionIndex.value] : null;
        let orderMap = Array.from((_b = (_a = optionsRef.value) == null ? void 0 : _a.querySelectorAll('[id^="headlessui-combobox-option-"]')) != null ? _b : []).reduce((lookup, element, index) => Object.assign(lookup, { [element.id]: index }), {});
        options.value = [...options.value, { id: id2, dataRef }].sort((a, z) => orderMap[a.id] - orderMap[z.id]);
        activeOptionIndex.value = (() => {
          if (currentActiveOption === null)
            return null;
          return options.value.indexOf(currentActiveOption);
        })();
      },
      unregisterOption(id2) {
        let nextOptions = options.value.slice();
        let currentActiveOption = activeOptionIndex.value !== null ? nextOptions[activeOptionIndex.value] : null;
        let idx = nextOptions.findIndex((a) => a.id === id2);
        if (idx !== -1)
          nextOptions.splice(idx, 1);
        options.value = nextOptions;
        activeOptionIndex.value = (() => {
          if (idx === activeOptionIndex.value)
            return null;
          if (currentActiveOption === null)
            return null;
          return nextOptions.indexOf(currentActiveOption);
        })();
      }
    };
    useWindowEvent("mousedown", (event) => {
      var _a, _b, _c;
      let target = event.target;
      if (comboboxState.value !== 0 /* Open */)
        return;
      if ((_a = dom(inputRef)) == null ? void 0 : _a.contains(target))
        return;
      if ((_b = dom(buttonRef)) == null ? void 0 : _b.contains(target))
        return;
      if ((_c = dom(optionsRef)) == null ? void 0 : _c.contains(target))
        return;
      api.closeCombobox();
    });
    (0, import_vue6.watch)([api.value, api.inputRef], () => api.syncInputValue(), { immediate: true });
    (0, import_vue6.provide)(ComboboxContext, api);
    useOpenClosedProvider((0, import_vue6.computed)(() => match(comboboxState.value, {
      [0 /* Open */]: 0 /* Open */,
      [1 /* Closed */]: 1 /* Closed */
    })));
    let activeOption = (0, import_vue6.computed)(() => activeOptionIndex.value === null ? null : options.value[activeOptionIndex.value].dataRef.value);
    return () => {
      let slot = {
        open: comboboxState.value === 0 /* Open */,
        disabled: props.disabled,
        activeIndex: activeOptionIndex.value,
        activeOption: activeOption.value
      };
      return render({
        props: omit(props, ["modelValue", "onUpdate:modelValue", "disabled"]),
        slot,
        slots,
        attrs,
        name: "Combobox"
      });
    };
  }
});
var ComboboxLabel = (0, import_vue6.defineComponent)({
  name: "ComboboxLabel",
  props: { as: { type: [Object, String], default: "label" } },
  setup(props, { attrs, slots }) {
    let api = useComboboxContext("ComboboxLabel");
    let id2 = `headlessui-combobox-label-${useId()}`;
    function handleClick() {
      var _a;
      (_a = dom(api.inputRef)) == null ? void 0 : _a.focus({ preventScroll: true });
    }
    return () => {
      let slot = {
        open: api.comboboxState.value === 0 /* Open */,
        disabled: api.disabled.value
      };
      let propsWeControl = { id: id2, ref: api.labelRef, onClick: handleClick };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ComboboxLabel"
      });
    };
  }
});
var ComboboxButton = (0, import_vue6.defineComponent)({
  name: "ComboboxButton",
  props: {
    as: { type: [Object, String], default: "button" }
  },
  setup(props, { attrs, slots }) {
    let api = useComboboxContext("ComboboxButton");
    let id2 = `headlessui-combobox-button-${useId()}`;
    function handleClick(event) {
      if (api.disabled.value)
        return;
      if (api.comboboxState.value === 0 /* Open */) {
        api.closeCombobox();
      } else {
        event.preventDefault();
        api.openCombobox();
      }
      (0, import_vue6.nextTick)(() => {
        var _a;
        return (_a = dom(api.inputRef)) == null ? void 0 : _a.focus({ preventScroll: true });
      });
    }
    function handleKeydown(event) {
      switch (event.key) {
        case "ArrowDown" /* ArrowDown */:
          event.preventDefault();
          event.stopPropagation();
          if (api.comboboxState.value === 1 /* Closed */) {
            api.openCombobox();
            (0, import_vue6.nextTick)(() => {
              if (!api.value.value) {
                api.goToOption(0 /* First */);
              }
            });
          }
          (0, import_vue6.nextTick)(() => {
            var _a;
            return (_a = api.inputRef.value) == null ? void 0 : _a.focus({ preventScroll: true });
          });
          return;
        case "ArrowUp" /* ArrowUp */:
          event.preventDefault();
          event.stopPropagation();
          if (api.comboboxState.value === 1 /* Closed */) {
            api.openCombobox();
            (0, import_vue6.nextTick)(() => {
              if (!api.value.value) {
                api.goToOption(3 /* Last */);
              }
            });
          }
          (0, import_vue6.nextTick)(() => {
            var _a;
            return (_a = api.inputRef.value) == null ? void 0 : _a.focus({ preventScroll: true });
          });
          return;
        case "Escape" /* Escape */:
          event.preventDefault();
          if (api.optionsRef.value && !api.optionsPropsRef.value.static) {
            event.stopPropagation();
          }
          api.closeCombobox();
          (0, import_vue6.nextTick)(() => {
            var _a;
            return (_a = api.inputRef.value) == null ? void 0 : _a.focus({ preventScroll: true });
          });
          return;
      }
    }
    let type = useResolveButtonType((0, import_vue6.computed)(() => ({ as: props.as, type: attrs.type })), api.buttonRef);
    return () => {
      var _a, _b;
      let slot = {
        open: api.comboboxState.value === 0 /* Open */,
        disabled: api.disabled.value
      };
      let propsWeControl = {
        ref: api.buttonRef,
        id: id2,
        type: type.value,
        tabindex: "-1",
        "aria-haspopup": true,
        "aria-controls": (_a = dom(api.optionsRef)) == null ? void 0 : _a.id,
        "aria-expanded": api.disabled.value ? void 0 : api.comboboxState.value === 0 /* Open */,
        "aria-labelledby": api.labelRef.value ? [(_b = dom(api.labelRef)) == null ? void 0 : _b.id, id2].join(" ") : void 0,
        disabled: api.disabled.value === true ? true : void 0,
        onKeydown: handleKeydown,
        onClick: handleClick
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ComboboxButton"
      });
    };
  }
});
var ComboboxInput = (0, import_vue6.defineComponent)({
  name: "ComboboxInput",
  props: {
    as: { type: [Object, String], default: "input" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true },
    displayValue: { type: Function }
  },
  emits: {
    change: (_value) => true
  },
  setup(props, { emit, attrs, slots }) {
    let api = useComboboxContext("ComboboxInput");
    let id2 = `headlessui-combobox-input-${useId()}`;
    api.inputPropsRef = (0, import_vue6.computed)(() => props);
    function handleKeyDown(event) {
      switch (event.key) {
        case "Enter" /* Enter */:
          event.preventDefault();
          event.stopPropagation();
          api.selectActiveOption();
          api.closeCombobox();
          break;
        case "ArrowDown" /* ArrowDown */:
          event.preventDefault();
          event.stopPropagation();
          return match(api.comboboxState.value, {
            [0 /* Open */]: () => api.goToOption(2 /* Next */),
            [1 /* Closed */]: () => {
              api.openCombobox();
              (0, import_vue6.nextTick)(() => {
                if (!api.value.value) {
                  api.goToOption(0 /* First */);
                }
              });
            }
          });
        case "ArrowUp" /* ArrowUp */:
          event.preventDefault();
          event.stopPropagation();
          return match(api.comboboxState.value, {
            [0 /* Open */]: () => api.goToOption(1 /* Previous */),
            [1 /* Closed */]: () => {
              api.openCombobox();
              (0, import_vue6.nextTick)(() => {
                if (!api.value.value) {
                  api.goToOption(3 /* Last */);
                }
              });
            }
          });
        case "Home" /* Home */:
        case "PageUp" /* PageUp */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(0 /* First */);
        case "End" /* End */:
        case "PageDown" /* PageDown */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(3 /* Last */);
        case "Escape" /* Escape */:
          event.preventDefault();
          if (api.optionsRef.value && !api.optionsPropsRef.value.static) {
            event.stopPropagation();
          }
          api.closeCombobox();
          break;
        case "Tab" /* Tab */:
          api.selectActiveOption();
          api.closeCombobox();
          break;
      }
    }
    function handleChange(event) {
      api.openCombobox();
      emit("change", event);
    }
    return () => {
      var _a, _b, _c, _d, _e;
      let slot = { open: api.comboboxState.value === 0 /* Open */ };
      let propsWeControl = {
        "aria-controls": (_a = api.optionsRef.value) == null ? void 0 : _a.id,
        "aria-expanded": api.disabled ? void 0 : api.comboboxState.value === 0 /* Open */,
        "aria-activedescendant": api.activeOptionIndex.value === null ? void 0 : (_b = api.options.value[api.activeOptionIndex.value]) == null ? void 0 : _b.id,
        "aria-labelledby": (_e = (_c = dom(api.labelRef)) == null ? void 0 : _c.id) != null ? _e : (_d = dom(api.buttonRef)) == null ? void 0 : _d.id,
        id: id2,
        onKeydown: handleKeyDown,
        onChange: handleChange,
        onInput: handleChange,
        role: "combobox",
        type: "text",
        tabIndex: 0,
        ref: api.inputRef
      };
      let passThroughProps = omit(props, ["displayValue"]);
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        name: "ComboboxInput"
      });
    };
  }
});
var ComboboxOptions = (0, import_vue6.defineComponent)({
  name: "ComboboxOptions",
  props: {
    as: { type: [Object, String], default: "ul" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true },
    hold: { type: [Boolean], default: false }
  },
  setup(props, { attrs, slots }) {
    let api = useComboboxContext("ComboboxOptions");
    let id2 = `headlessui-combobox-options-${useId()}`;
    (0, import_vue6.watchEffect)(() => {
      api.optionsPropsRef.value.static = props.static;
    });
    (0, import_vue6.watchEffect)(() => {
      api.optionsPropsRef.value.hold = props.hold;
    });
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue6.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.comboboxState.value === 0 /* Open */;
    });
    useTreeWalker({
      container: (0, import_vue6.computed)(() => dom(api.optionsRef)),
      enabled: (0, import_vue6.computed)(() => api.comboboxState.value === 0 /* Open */),
      accept(node) {
        if (node.getAttribute("role") === "option")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk(node) {
        node.setAttribute("role", "none");
      }
    });
    return () => {
      var _a, _b, _c, _d;
      let slot = { open: api.comboboxState.value === 0 /* Open */ };
      let propsWeControl = {
        "aria-activedescendant": api.activeOptionIndex.value === null ? void 0 : (_a = api.options.value[api.activeOptionIndex.value]) == null ? void 0 : _a.id,
        "aria-labelledby": (_d = (_b = dom(api.labelRef)) == null ? void 0 : _b.id) != null ? _d : (_c = dom(api.buttonRef)) == null ? void 0 : _c.id,
        id: id2,
        ref: api.optionsRef,
        role: "listbox"
      };
      let passThroughProps = omit(props, ["hold"]);
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "ComboboxOptions"
      });
    };
  }
});
var ComboboxOption = (0, import_vue6.defineComponent)({
  name: "ComboboxOption",
  props: {
    as: { type: [Object, String], default: "li" },
    value: { type: [Object, String, Number, Boolean] },
    disabled: { type: Boolean, default: false }
  },
  setup(props, { slots, attrs }) {
    let api = useComboboxContext("ComboboxOption");
    let id2 = `headlessui-combobox-option-${useId()}`;
    let active = (0, import_vue6.computed)(() => {
      return api.activeOptionIndex.value !== null ? api.options.value[api.activeOptionIndex.value].id === id2 : false;
    });
    let selected = (0, import_vue6.computed)(() => (0, import_vue6.toRaw)(api.value.value) === (0, import_vue6.toRaw)(props.value));
    let dataRef = (0, import_vue6.computed)(() => ({
      disabled: props.disabled,
      value: props.value
    }));
    (0, import_vue6.onMounted)(() => api.registerOption(id2, dataRef));
    (0, import_vue6.onUnmounted)(() => api.unregisterOption(id2));
    (0, import_vue6.onMounted)(() => {
      (0, import_vue6.watch)([api.comboboxState, selected], () => {
        if (api.comboboxState.value !== 0 /* Open */)
          return;
        if (!selected.value)
          return;
        api.goToOption(4 /* Specific */, id2);
      }, { immediate: true });
    });
    (0, import_vue6.watchEffect)(() => {
      if (api.comboboxState.value !== 0 /* Open */)
        return;
      if (!active.value)
        return;
      (0, import_vue6.nextTick)(() => {
        var _a, _b;
        return (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.scrollIntoView) == null ? void 0 : _b.call(_a, { block: "nearest" });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.selectOption(id2);
      api.closeCombobox();
      (0, import_vue6.nextTick)(() => {
        var _a;
        return (_a = dom(api.inputRef)) == null ? void 0 : _a.focus({ preventScroll: true });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToOption(5 /* Nothing */);
      api.goToOption(4 /* Specific */, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToOption(4 /* Specific */, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      if (api.optionsPropsRef.value.hold)
        return;
      api.goToOption(5 /* Nothing */);
    }
    return () => {
      let { disabled } = props;
      let slot = { active: active.value, selected: selected.value, disabled };
      let propsWeControl = {
        id: id2,
        role: "option",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        "aria-selected": selected.value === true ? selected.value : void 0,
        disabled: void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ComboboxOption"
      });
    };
  }
});

// src/components/dialog/dialog.ts
var import_vue13 = require("vue");

// src/hooks/use-focus-trap.ts
var import_vue7 = require("vue");

// src/utils/focus-management.ts
var focusableSelector = [
  "[contentEditable=true]",
  "[tabindex]",
  "a[href]",
  "area[href]",
  "button:not([disabled])",
  "iframe",
  "input:not([disabled])",
  "select:not([disabled])",
  "textarea:not([disabled])"
].map(false ? (selector) => `${selector}:not([tabindex='-1']):not([style*='display: none'])` : (selector) => `${selector}:not([tabindex='-1'])`).join(",");
function getFocusableElements(container = document.body) {
  if (container == null)
    return [];
  return Array.from(container.querySelectorAll(focusableSelector));
}
function isFocusableElement(element, mode = 0 /* Strict */) {
  if (element === document.body)
    return false;
  return match(mode, {
    [0 /* Strict */]() {
      return element.matches(focusableSelector);
    },
    [1 /* Loose */]() {
      let next = element;
      while (next !== null) {
        if (next.matches(focusableSelector))
          return true;
        next = next.parentElement;
      }
      return false;
    }
  });
}
function focusElement(element) {
  element == null ? void 0 : element.focus({ preventScroll: true });
}
function focusIn(container, focus) {
  let elements = Array.isArray(container) ? container.slice().sort((a, z) => {
    let position = a.compareDocumentPosition(z);
    if (position & Node.DOCUMENT_POSITION_FOLLOWING)
      return -1;
    if (position & Node.DOCUMENT_POSITION_PRECEDING)
      return 1;
    return 0;
  }) : getFocusableElements(container);
  let active = document.activeElement;
  let direction = (() => {
    if (focus & (1 /* First */ | 4 /* Next */))
      return 1 /* Next */;
    if (focus & (2 /* Previous */ | 8 /* Last */))
      return -1 /* Previous */;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })();
  let startIndex = (() => {
    if (focus & 1 /* First */)
      return 0;
    if (focus & 2 /* Previous */)
      return Math.max(0, elements.indexOf(active)) - 1;
    if (focus & 4 /* Next */)
      return Math.max(0, elements.indexOf(active)) + 1;
    if (focus & 8 /* Last */)
      return elements.length - 1;
    throw new Error("Missing Focus.First, Focus.Previous, Focus.Next or Focus.Last");
  })();
  let focusOptions = focus & 32 /* NoScroll */ ? { preventScroll: true } : {};
  let offset = 0;
  let total = elements.length;
  let next = void 0;
  do {
    if (offset >= total || offset + total <= 0)
      return 0 /* Error */;
    let nextIdx = startIndex + offset;
    if (focus & 16 /* WrapAround */) {
      nextIdx = (nextIdx + total) % total;
    } else {
      if (nextIdx < 0)
        return 3 /* Underflow */;
      if (nextIdx >= total)
        return 1 /* Overflow */;
    }
    next = elements[nextIdx];
    next == null ? void 0 : next.focus(focusOptions);
    offset += direction;
  } while (next !== document.activeElement);
  if (!next.hasAttribute("tabindex"))
    next.setAttribute("tabindex", "0");
  return 2 /* Success */;
}

// src/internal/dom-containers.ts
function contains(containers, element) {
  for (let container of containers) {
    if (container.contains(element))
      return true;
  }
  return false;
}

// src/hooks/use-focus-trap.ts
function useFocusTrap(containers, enabled = (0, import_vue7.ref)(true), options = (0, import_vue7.ref)({})) {
  let restoreElement = (0, import_vue7.ref)(typeof window !== "undefined" ? document.activeElement : null);
  let previousActiveElement = (0, import_vue7.ref)(null);
  function handleFocus() {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    let { initialFocus } = options.value;
    let activeElement = document.activeElement;
    if (initialFocus) {
      if (initialFocus === activeElement) {
        return;
      }
    } else if (contains(containers.value, activeElement)) {
      return;
    }
    restoreElement.value = activeElement;
    if (initialFocus) {
      focusElement(initialFocus);
    } else {
      let couldFocus = false;
      for (let container of containers.value) {
        let result = focusIn(container, 1 /* First */);
        if (result === 2 /* Success */) {
          couldFocus = true;
          break;
        }
      }
      if (!couldFocus)
        console.warn("There are no focusable elements inside the <FocusTrap />");
    }
    previousActiveElement.value = document.activeElement;
  }
  function restore2() {
    focusElement(restoreElement.value);
    restoreElement.value = null;
    previousActiveElement.value = null;
  }
  (0, import_vue7.watchEffect)(handleFocus);
  (0, import_vue7.onUpdated)(() => {
    enabled.value ? handleFocus() : restore2();
  });
  (0, import_vue7.onUnmounted)(restore2);
  useWindowEvent("keydown", (event) => {
    if (!enabled.value)
      return;
    if (event.key !== "Tab" /* Tab */)
      return;
    if (!document.activeElement)
      return;
    if (containers.value.size !== 1)
      return;
    event.preventDefault();
    for (let element of containers.value) {
      let result = focusIn(element, (event.shiftKey ? 2 /* Previous */ : 4 /* Next */) | 16 /* WrapAround */);
      if (result === 2 /* Success */) {
        previousActiveElement.value = document.activeElement;
        break;
      }
    }
  });
  useWindowEvent("focus", (event) => {
    if (!enabled.value)
      return;
    if (containers.value.size !== 1)
      return;
    let previous = previousActiveElement.value;
    if (!previous)
      return;
    let toElement = event.target;
    if (toElement && toElement instanceof HTMLElement) {
      if (!contains(containers.value, toElement)) {
        event.preventDefault();
        event.stopPropagation();
        focusElement(previous);
      } else {
        previousActiveElement.value = toElement;
        focusElement(toElement);
      }
    } else {
      focusElement(previousActiveElement.value);
    }
  }, true);
}

// src/hooks/use-inert-others.ts
var import_vue8 = require("vue");
var CHILDREN_SELECTOR = false ? '[data-v-app=""] > *' : "body > *";
var interactables = /* @__PURE__ */ new Set();
var originals = /* @__PURE__ */ new Map();
function inert(element) {
  element.setAttribute("aria-hidden", "true");
  element.inert = true;
}
function restore(element) {
  let original = originals.get(element);
  if (!original)
    return;
  if (original["aria-hidden"] === null)
    element.removeAttribute("aria-hidden");
  else
    element.setAttribute("aria-hidden", original["aria-hidden"]);
  element.inert = original.inert;
}
function useInertOthers(container, enabled = (0, import_vue8.ref)(true)) {
  (0, import_vue8.watchEffect)((onInvalidate) => {
    if (!enabled.value)
      return;
    if (!container.value)
      return;
    let element = container.value;
    interactables.add(element);
    for (let original of originals.keys()) {
      if (original.contains(element)) {
        restore(original);
        originals.delete(original);
      }
    }
    document.querySelectorAll(CHILDREN_SELECTOR).forEach((child) => {
      if (!(child instanceof HTMLElement))
        return;
      for (let interactable of interactables) {
        if (child.contains(interactable))
          return;
      }
      if (interactables.size === 1) {
        originals.set(child, {
          "aria-hidden": child.getAttribute("aria-hidden"),
          inert: child.inert
        });
        inert(child);
      }
    });
    onInvalidate(() => {
      interactables.delete(element);
      if (interactables.size > 0) {
        document.querySelectorAll(CHILDREN_SELECTOR).forEach((child) => {
          if (!(child instanceof HTMLElement))
            return;
          if (originals.has(child))
            return;
          for (let interactable of interactables) {
            if (child.contains(interactable))
              return;
          }
          originals.set(child, {
            "aria-hidden": child.getAttribute("aria-hidden"),
            inert: child.inert
          });
          inert(child);
        });
      } else {
        for (let element2 of originals.keys()) {
          restore(element2);
          originals.delete(element2);
        }
      }
    });
  });
}

// src/components/portal/portal.ts
var import_vue11 = require("vue");

// src/internal/stack-context.ts
var import_vue9 = require("vue");
var StackContext = Symbol("StackContext");
function useStackContext() {
  return (0, import_vue9.inject)(StackContext, () => {
  });
}
function useElemenStack(element) {
  let notify = useStackContext();
  (0, import_vue9.watchEffect)((onInvalidate) => {
    let domElement = element == null ? void 0 : element.value;
    if (!domElement)
      return;
    notify(0 /* AddElement */, domElement);
    onInvalidate(() => notify(1 /* RemoveElement */, domElement));
  });
}
function useStackProvider(onUpdate) {
  let parentUpdate = useStackContext();
  function notify(...args) {
    onUpdate == null ? void 0 : onUpdate(...args);
    parentUpdate(...args);
  }
  (0, import_vue9.provide)(StackContext, notify);
}

// src/internal/portal-force-root.ts
var import_vue10 = require("vue");
var ForcePortalRootContext = Symbol("ForcePortalRootContext");
function usePortalRoot() {
  return (0, import_vue10.inject)(ForcePortalRootContext, false);
}
var ForcePortalRoot = (0, import_vue10.defineComponent)({
  name: "ForcePortalRoot",
  props: {
    as: { type: [Object, String], default: "template" },
    force: { type: Boolean, default: false }
  },
  setup(props, { slots, attrs }) {
    (0, import_vue10.provide)(ForcePortalRootContext, props.force);
    return () => {
      let { force, ...passThroughProps } = props;
      return render({ props: passThroughProps, slot: {}, slots, attrs, name: "ForcePortalRoot" });
    };
  }
});

// src/components/portal/portal.ts
function getPortalRoot() {
  let existingRoot = document.getElementById("headlessui-portal-root");
  if (existingRoot)
    return existingRoot;
  let root = document.createElement("div");
  root.setAttribute("id", "headlessui-portal-root");
  return document.body.appendChild(root);
}
var Portal = (0, import_vue11.defineComponent)({
  name: "Portal",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { slots, attrs }) {
    let forcePortalRoot = usePortalRoot();
    let groupContext = (0, import_vue11.inject)(PortalGroupContext, null);
    let myTarget = (0, import_vue11.ref)(forcePortalRoot === true ? getPortalRoot() : groupContext === null ? getPortalRoot() : groupContext.resolveTarget());
    (0, import_vue11.watchEffect)(() => {
      if (forcePortalRoot)
        return;
      if (groupContext === null)
        return;
      myTarget.value = groupContext.resolveTarget();
    });
    let element = (0, import_vue11.ref)(null);
    useElemenStack(element);
    (0, import_vue11.onUnmounted)(() => {
      var _a;
      let root = document.getElementById("headlessui-portal-root");
      if (!root)
        return;
      if (myTarget.value !== root)
        return;
      if (myTarget.value.children.length <= 0) {
        (_a = myTarget.value.parentElement) == null ? void 0 : _a.removeChild(myTarget.value);
      }
    });
    useStackProvider();
    return () => {
      if (myTarget.value === null)
        return null;
      let propsWeControl = {
        ref: element
      };
      return (0, import_vue11.h)(import_vue11.Teleport, { to: myTarget.value }, render({
        props: { ...props, ...propsWeControl },
        slot: {},
        attrs,
        slots,
        name: "Portal"
      }));
    };
  }
});
var PortalGroupContext = Symbol("PortalGroupContext");
var PortalGroup = (0, import_vue11.defineComponent)({
  name: "PortalGroup",
  props: {
    as: { type: [Object, String], default: "template" },
    target: { type: Object, default: null }
  },
  setup(props, { attrs, slots }) {
    let api = (0, import_vue11.reactive)({
      resolveTarget() {
        return props.target;
      }
    });
    (0, import_vue11.provide)(PortalGroupContext, api);
    return () => {
      let { target: _, ...passThroughProps } = props;
      return render({ props: passThroughProps, slot: {}, attrs, slots, name: "PortalGroup" });
    };
  }
});

// src/components/description/description.ts
var import_vue12 = require("vue");
var DescriptionContext = Symbol("DescriptionContext");
function useDescriptionContext() {
  let context = (0, import_vue12.inject)(DescriptionContext, null);
  if (context === null) {
    throw new Error("Missing parent");
  }
  return context;
}
function useDescriptions({
  slot = (0, import_vue12.ref)({}),
  name = "Description",
  props = {}
} = {}) {
  let descriptionIds = (0, import_vue12.ref)([]);
  function register(value) {
    descriptionIds.value.push(value);
    return () => {
      let idx = descriptionIds.value.indexOf(value);
      if (idx === -1)
        return;
      descriptionIds.value.splice(idx, 1);
    };
  }
  (0, import_vue12.provide)(DescriptionContext, { register, slot, name, props });
  return (0, import_vue12.computed)(() => descriptionIds.value.length > 0 ? descriptionIds.value.join(" ") : void 0);
}
var Description = (0, import_vue12.defineComponent)({
  name: "Description",
  props: {
    as: { type: [Object, String], default: "p" }
  },
  setup(myProps, { attrs, slots }) {
    let context = useDescriptionContext();
    let id2 = `headlessui-description-${useId()}`;
    (0, import_vue12.onMounted)(() => (0, import_vue12.onUnmounted)(context.register(id2)));
    return () => {
      let { name = "Description", slot = (0, import_vue12.ref)({}), props = {} } = context;
      let passThroughProps = myProps;
      let propsWeControl = {
        ...Object.entries(props).reduce((acc, [key, value]) => Object.assign(acc, { [key]: (0, import_vue12.unref)(value) }), {}),
        id: id2
      };
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot: slot.value,
        attrs,
        slots,
        name
      });
    };
  }
});

// src/components/dialog/dialog.ts
var DialogContext = Symbol("DialogContext");
function useDialogContext(component) {
  let context = (0, import_vue13.inject)(DialogContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <Dialog /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useDialogContext);
    throw err;
  }
  return context;
}
var Missing = "DC8F892D-2EBD-447C-A4C8-A03058436FF4";
var Dialog = (0, import_vue13.defineComponent)({
  name: "Dialog",
  inheritAttrs: false,
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true },
    open: { type: [Boolean, String], default: Missing },
    initialFocus: { type: Object, default: null }
  },
  emits: { close: (_close) => true },
  setup(props, { emit, attrs, slots }) {
    let containers = (0, import_vue13.ref)(/* @__PURE__ */ new Set());
    let usesOpenClosedState = useOpenClosed();
    let open = (0, import_vue13.computed)(() => {
      if (props.open === Missing && usesOpenClosedState !== null) {
        return match(usesOpenClosedState.value, {
          [0 /* Open */]: true,
          [1 /* Closed */]: false
        });
      }
      return props.open;
    });
    let hasOpen = props.open !== Missing || usesOpenClosedState !== null;
    if (!hasOpen) {
      throw new Error(`You forgot to provide an \`open\` prop to the \`Dialog\`.`);
    }
    if (typeof open.value !== "boolean") {
      throw new Error(`You provided an \`open\` prop to the \`Dialog\`, but the value is not a boolean. Received: ${open.value === Missing ? void 0 : props.open}`);
    }
    let dialogState = (0, import_vue13.computed)(() => props.open ? 0 /* Open */ : 1 /* Closed */);
    let visible = (0, import_vue13.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return dialogState.value === 0 /* Open */;
    });
    let internalDialogRef = (0, import_vue13.ref)(null);
    let enabled = (0, import_vue13.ref)(dialogState.value === 0 /* Open */);
    (0, import_vue13.onUpdated)(() => {
      enabled.value = dialogState.value === 0 /* Open */;
    });
    let id2 = `headlessui-dialog-${useId()}`;
    let focusTrapOptions = (0, import_vue13.computed)(() => ({ initialFocus: props.initialFocus }));
    useFocusTrap(containers, enabled, focusTrapOptions);
    useInertOthers(internalDialogRef, enabled);
    useStackProvider((message, element) => {
      return match(message, {
        [0 /* AddElement */]() {
          containers.value.add(element);
        },
        [1 /* RemoveElement */]() {
          containers.value.delete(element);
        }
      });
    });
    let describedby = useDescriptions({
      name: "DialogDescription",
      slot: (0, import_vue13.computed)(() => ({ open: open.value }))
    });
    let titleId = (0, import_vue13.ref)(null);
    let api = {
      titleId,
      dialogState,
      setTitleId(id3) {
        if (titleId.value === id3)
          return;
        titleId.value = id3;
      },
      close() {
        emit("close", false);
      }
    };
    (0, import_vue13.provide)(DialogContext, api);
    useWindowEvent("mousedown", (event) => {
      let target = event.target;
      if (dialogState.value !== 0 /* Open */)
        return;
      if (containers.value.size !== 1)
        return;
      if (contains(containers.value, target))
        return;
      api.close();
      (0, import_vue13.nextTick)(() => target == null ? void 0 : target.focus());
    });
    useWindowEvent("keydown", (event) => {
      if (event.key !== "Escape" /* Escape */)
        return;
      if (dialogState.value !== 0 /* Open */)
        return;
      if (containers.value.size > 1)
        return;
      event.preventDefault();
      event.stopPropagation();
      api.close();
    });
    (0, import_vue13.watchEffect)((onInvalidate) => {
      if (dialogState.value !== 0 /* Open */)
        return;
      let overflow = document.documentElement.style.overflow;
      let paddingRight = document.documentElement.style.paddingRight;
      let scrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
      document.documentElement.style.overflow = "hidden";
      document.documentElement.style.paddingRight = `${scrollbarWidth}px`;
      onInvalidate(() => {
        document.documentElement.style.overflow = overflow;
        document.documentElement.style.paddingRight = paddingRight;
      });
    });
    (0, import_vue13.watchEffect)((onInvalidate) => {
      if (dialogState.value !== 0 /* Open */)
        return;
      let container = dom(internalDialogRef);
      if (!container)
        return;
      let observer = new IntersectionObserver((entries) => {
        for (let entry of entries) {
          if (entry.boundingClientRect.x === 0 && entry.boundingClientRect.y === 0 && entry.boundingClientRect.width === 0 && entry.boundingClientRect.height === 0) {
            api.close();
          }
        }
      });
      observer.observe(container);
      onInvalidate(() => observer.disconnect());
    });
    function handleClick(event) {
      event.stopPropagation();
    }
    return () => {
      let propsWeControl = {
        ...attrs,
        ref: internalDialogRef,
        id: id2,
        role: "dialog",
        "aria-modal": dialogState.value === 0 /* Open */ ? true : void 0,
        "aria-labelledby": titleId.value,
        "aria-describedby": describedby.value,
        onClick: handleClick
      };
      let { open: _, initialFocus, ...passThroughProps } = props;
      let slot = { open: dialogState.value === 0 /* Open */ };
      return (0, import_vue13.h)(ForcePortalRoot, { force: true }, () => (0, import_vue13.h)(Portal, () => (0, import_vue13.h)(PortalGroup, { target: internalDialogRef.value }, () => (0, import_vue13.h)(ForcePortalRoot, { force: false }, () => render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        visible: visible.value,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        name: "Dialog"
      })))));
    };
  }
});
var DialogOverlay = (0, import_vue13.defineComponent)({
  name: "DialogOverlay",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { attrs, slots }) {
    let api = useDialogContext("DialogOverlay");
    let id2 = `headlessui-dialog-overlay-${useId()}`;
    function handleClick(event) {
      if (event.target !== event.currentTarget)
        return;
      event.preventDefault();
      event.stopPropagation();
      api.close();
    }
    return () => {
      let propsWeControl = {
        id: id2,
        "aria-hidden": true,
        onClick: handleClick
      };
      let passThroughProps = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot: { open: api.dialogState.value === 0 /* Open */ },
        attrs,
        slots,
        name: "DialogOverlay"
      });
    };
  }
});
var DialogTitle = (0, import_vue13.defineComponent)({
  name: "DialogTitle",
  props: {
    as: { type: [Object, String], default: "h2" }
  },
  setup(props, { attrs, slots }) {
    let api = useDialogContext("DialogTitle");
    let id2 = `headlessui-dialog-title-${useId()}`;
    (0, import_vue13.onMounted)(() => {
      api.setTitleId(id2);
      (0, import_vue13.onUnmounted)(() => api.setTitleId(null));
    });
    return () => {
      let propsWeControl = { id: id2 };
      let passThroughProps = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot: { open: api.dialogState.value === 0 /* Open */ },
        attrs,
        slots,
        name: "DialogTitle"
      });
    };
  }
});
var DialogDescription = Description;

// src/components/disclosure/disclosure.ts
var import_vue14 = require("vue");
var DisclosureContext = Symbol("DisclosureContext");
function useDisclosureContext(component) {
  let context = (0, import_vue14.inject)(DisclosureContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <Disclosure /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useDisclosureContext);
    throw err;
  }
  return context;
}
var DisclosurePanelContext = Symbol("DisclosurePanelContext");
function useDisclosurePanelContext() {
  return (0, import_vue14.inject)(DisclosurePanelContext, null);
}
var Disclosure = (0, import_vue14.defineComponent)({
  name: "Disclosure",
  props: {
    as: { type: [Object, String], default: "template" },
    defaultOpen: { type: [Boolean], default: false }
  },
  setup(props, { slots, attrs }) {
    let buttonId = `headlessui-disclosure-button-${useId()}`;
    let panelId = `headlessui-disclosure-panel-${useId()}`;
    let disclosureState = (0, import_vue14.ref)(props.defaultOpen ? 0 /* Open */ : 1 /* Closed */);
    let panelRef = (0, import_vue14.ref)(null);
    let buttonRef = (0, import_vue14.ref)(null);
    let api = {
      buttonId,
      panelId,
      disclosureState,
      panel: panelRef,
      button: buttonRef,
      toggleDisclosure() {
        disclosureState.value = match(disclosureState.value, {
          [0 /* Open */]: 1 /* Closed */,
          [1 /* Closed */]: 0 /* Open */
        });
      },
      closeDisclosure() {
        if (disclosureState.value === 1 /* Closed */)
          return;
        disclosureState.value = 1 /* Closed */;
      },
      close(focusableElement) {
        api.closeDisclosure();
        let restoreElement = (() => {
          if (!focusableElement)
            return dom(api.button);
          if (focusableElement instanceof HTMLElement)
            return focusableElement;
          if (focusableElement.value instanceof HTMLElement)
            return dom(focusableElement);
          return dom(api.button);
        })();
        restoreElement == null ? void 0 : restoreElement.focus();
      }
    };
    (0, import_vue14.provide)(DisclosureContext, api);
    useOpenClosedProvider((0, import_vue14.computed)(() => {
      return match(disclosureState.value, {
        [0 /* Open */]: 0 /* Open */,
        [1 /* Closed */]: 1 /* Closed */
      });
    }));
    return () => {
      let { defaultOpen: _, ...passThroughProps } = props;
      let slot = { open: disclosureState.value === 0 /* Open */, close: api.close };
      return render({ props: passThroughProps, slot, slots, attrs, name: "Disclosure" });
    };
  }
});
var DisclosureButton = (0, import_vue14.defineComponent)({
  name: "DisclosureButton",
  props: {
    as: { type: [Object, String], default: "button" },
    disabled: { type: [Boolean], default: false }
  },
  setup(props, { attrs, slots }) {
    let api = useDisclosureContext("DisclosureButton");
    let panelContext = useDisclosurePanelContext();
    let isWithinPanel = panelContext === null ? false : panelContext === api.panelId;
    let elementRef = (0, import_vue14.ref)(null);
    if (!isWithinPanel) {
      (0, import_vue14.watchEffect)(() => {
        api.button.value = elementRef.value;
      });
    }
    let type = useResolveButtonType((0, import_vue14.computed)(() => ({ as: props.as, type: attrs.type })), elementRef);
    function handleClick() {
      var _a;
      if (props.disabled)
        return;
      if (isWithinPanel) {
        api.toggleDisclosure();
        (_a = dom(api.button)) == null ? void 0 : _a.focus();
      } else {
        api.toggleDisclosure();
      }
    }
    function handleKeyDown(event) {
      var _a;
      if (props.disabled)
        return;
      if (isWithinPanel) {
        switch (event.key) {
          case " " /* Space */:
          case "Enter" /* Enter */:
            event.preventDefault();
            event.stopPropagation();
            api.toggleDisclosure();
            (_a = dom(api.button)) == null ? void 0 : _a.focus();
            break;
        }
      } else {
        switch (event.key) {
          case " " /* Space */:
          case "Enter" /* Enter */:
            event.preventDefault();
            event.stopPropagation();
            api.toggleDisclosure();
            break;
        }
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case " " /* Space */:
          event.preventDefault();
          break;
      }
    }
    return () => {
      let slot = { open: api.disclosureState.value === 0 /* Open */ };
      let propsWeControl = isWithinPanel ? {
        ref: elementRef,
        type: type.value,
        onClick: handleClick,
        onKeydown: handleKeyDown
      } : {
        id: api.buttonId,
        ref: elementRef,
        type: type.value,
        "aria-expanded": props.disabled ? void 0 : api.disclosureState.value === 0 /* Open */,
        "aria-controls": dom(api.panel) ? api.panelId : void 0,
        disabled: props.disabled ? true : void 0,
        onClick: handleClick,
        onKeydown: handleKeyDown,
        onKeyup: handleKeyUp
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "DisclosureButton"
      });
    };
  }
});
var DisclosurePanel = (0, import_vue14.defineComponent)({
  name: "DisclosurePanel",
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true }
  },
  setup(props, { attrs, slots }) {
    let api = useDisclosureContext("DisclosurePanel");
    (0, import_vue14.provide)(DisclosurePanelContext, api.panelId);
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue14.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.disclosureState.value === 0 /* Open */;
    });
    return () => {
      let slot = { open: api.disclosureState.value === 0 /* Open */, close: api.close };
      let propsWeControl = { id: api.panelId, ref: api.panel };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "DisclosurePanel"
      });
    };
  }
});

// src/components/focus-trap/focus-trap.ts
var import_vue15 = require("vue");
var FocusTrap = (0, import_vue15.defineComponent)({
  name: "FocusTrap",
  props: {
    as: { type: [Object, String], default: "div" },
    initialFocus: { type: Object, default: null }
  },
  setup(props, { attrs, slots }) {
    let containers = (0, import_vue15.ref)(/* @__PURE__ */ new Set());
    let container = (0, import_vue15.ref)(null);
    let enabled = (0, import_vue15.ref)(true);
    let focusTrapOptions = (0, import_vue15.computed)(() => ({ initialFocus: props.initialFocus }));
    (0, import_vue15.onMounted)(() => {
      if (!container.value)
        return;
      containers.value.add(container.value);
      useFocusTrap(containers, enabled, focusTrapOptions);
    });
    (0, import_vue15.onUnmounted)(() => {
      enabled.value = false;
    });
    return () => {
      let slot = {};
      let propsWeControl = { ref: container };
      let { initialFocus, ...passThroughProps } = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "FocusTrap"
      });
    };
  }
});

// src/components/listbox/listbox.ts
var import_vue16 = require("vue");
function nextFrame(cb) {
  requestAnimationFrame(() => requestAnimationFrame(cb));
}
var ListboxContext = Symbol("ListboxContext");
function useListboxContext(component) {
  let context = (0, import_vue16.inject)(ListboxContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <Listbox /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useListboxContext);
    throw err;
  }
  return context;
}
var Listbox = (0, import_vue16.defineComponent)({
  name: "Listbox",
  emits: { "update:modelValue": (_value) => true },
  props: {
    as: { type: [Object, String], default: "template" },
    disabled: { type: [Boolean], default: false },
    horizontal: { type: [Boolean], default: false },
    modelValue: { type: [Object, String, Number, Boolean] }
  },
  setup(props, { slots, attrs, emit }) {
    let listboxState = (0, import_vue16.ref)(1 /* Closed */);
    let labelRef = (0, import_vue16.ref)(null);
    let buttonRef = (0, import_vue16.ref)(null);
    let optionsRef = (0, import_vue16.ref)(null);
    let options = (0, import_vue16.ref)([]);
    let searchQuery = (0, import_vue16.ref)("");
    let activeOptionIndex = (0, import_vue16.ref)(null);
    let value = (0, import_vue16.computed)(() => props.modelValue);
    let api = {
      listboxState,
      value,
      orientation: (0, import_vue16.computed)(() => props.horizontal ? "horizontal" : "vertical"),
      labelRef,
      buttonRef,
      optionsRef,
      disabled: (0, import_vue16.computed)(() => props.disabled),
      options,
      searchQuery,
      activeOptionIndex,
      closeListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === 1 /* Closed */)
          return;
        listboxState.value = 1 /* Closed */;
        activeOptionIndex.value = null;
      },
      openListbox() {
        if (props.disabled)
          return;
        if (listboxState.value === 0 /* Open */)
          return;
        listboxState.value = 0 /* Open */;
      },
      goToOption(focus, id2) {
        if (props.disabled)
          return;
        if (listboxState.value === 1 /* Closed */)
          return;
        let nextActiveOptionIndex = calculateActiveIndex(focus === 4 /* Specific */ ? { focus: 4 /* Specific */, id: id2 } : { focus }, {
          resolveItems: () => options.value,
          resolveActiveIndex: () => activeOptionIndex.value,
          resolveId: (option) => option.id,
          resolveDisabled: (option) => option.dataRef.disabled
        });
        if (searchQuery.value === "" && activeOptionIndex.value === nextActiveOptionIndex)
          return;
        searchQuery.value = "";
        activeOptionIndex.value = nextActiveOptionIndex;
      },
      search(value2) {
        if (props.disabled)
          return;
        if (listboxState.value === 1 /* Closed */)
          return;
        let wasAlreadySearching = searchQuery.value !== "";
        let offset = wasAlreadySearching ? 0 : 1;
        searchQuery.value += value2.toLowerCase();
        let reOrderedOptions = activeOptionIndex.value !== null ? options.value.slice(activeOptionIndex.value + offset).concat(options.value.slice(0, activeOptionIndex.value + offset)) : options.value;
        let matchingOption = reOrderedOptions.find((option) => option.dataRef.textValue.startsWith(searchQuery.value) && !option.dataRef.disabled);
        let matchIdx = matchingOption ? options.value.indexOf(matchingOption) : -1;
        if (matchIdx === -1 || matchIdx === activeOptionIndex.value)
          return;
        activeOptionIndex.value = matchIdx;
      },
      clearSearch() {
        if (props.disabled)
          return;
        if (listboxState.value === 1 /* Closed */)
          return;
        if (searchQuery.value === "")
          return;
        searchQuery.value = "";
      },
      registerOption(id2, dataRef) {
        var _a, _b;
        let orderMap = Array.from((_b = (_a = optionsRef.value) == null ? void 0 : _a.querySelectorAll('[id^="headlessui-listbox-option-"]')) != null ? _b : []).reduce((lookup, element, index) => Object.assign(lookup, { [element.id]: index }), {});
        options.value = [...options.value, { id: id2, dataRef }].sort((a, z) => orderMap[a.id] - orderMap[z.id]);
      },
      unregisterOption(id2) {
        let nextOptions = options.value.slice();
        let currentActiveOption = activeOptionIndex.value !== null ? nextOptions[activeOptionIndex.value] : null;
        let idx = nextOptions.findIndex((a) => a.id === id2);
        if (idx !== -1)
          nextOptions.splice(idx, 1);
        options.value = nextOptions;
        activeOptionIndex.value = (() => {
          if (idx === activeOptionIndex.value)
            return null;
          if (currentActiveOption === null)
            return null;
          return nextOptions.indexOf(currentActiveOption);
        })();
      },
      select(value2) {
        if (props.disabled)
          return;
        emit("update:modelValue", value2);
      }
    };
    useWindowEvent("mousedown", (event) => {
      var _a, _b, _c;
      let target = event.target;
      let active = document.activeElement;
      if (listboxState.value !== 0 /* Open */)
        return;
      if ((_a = dom(buttonRef)) == null ? void 0 : _a.contains(target))
        return;
      if (!((_b = dom(optionsRef)) == null ? void 0 : _b.contains(target)))
        api.closeListbox();
      if (active !== document.body && (active == null ? void 0 : active.contains(target)))
        return;
      if (!event.defaultPrevented)
        (_c = dom(buttonRef)) == null ? void 0 : _c.focus({ preventScroll: true });
    });
    (0, import_vue16.provide)(ListboxContext, api);
    useOpenClosedProvider((0, import_vue16.computed)(() => match(listboxState.value, {
      [0 /* Open */]: 0 /* Open */,
      [1 /* Closed */]: 1 /* Closed */
    })));
    return () => {
      let slot = { open: listboxState.value === 0 /* Open */, disabled: props.disabled };
      return render({
        props: omit(props, ["modelValue", "onUpdate:modelValue", "disabled", "horizontal"]),
        slot,
        slots,
        attrs,
        name: "Listbox"
      });
    };
  }
});
var ListboxLabel = (0, import_vue16.defineComponent)({
  name: "ListboxLabel",
  props: { as: { type: [Object, String], default: "label" } },
  setup(props, { attrs, slots }) {
    let api = useListboxContext("ListboxLabel");
    let id2 = `headlessui-listbox-label-${useId()}`;
    function handleClick() {
      var _a;
      (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
    }
    return () => {
      let slot = {
        open: api.listboxState.value === 0 /* Open */,
        disabled: api.disabled.value
      };
      let propsWeControl = { id: id2, ref: api.labelRef, onClick: handleClick };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ListboxLabel"
      });
    };
  }
});
var ListboxButton = (0, import_vue16.defineComponent)({
  name: "ListboxButton",
  props: {
    as: { type: [Object, String], default: "button" }
  },
  setup(props, { attrs, slots }) {
    let api = useListboxContext("ListboxButton");
    let id2 = `headlessui-listbox-button-${useId()}`;
    function handleKeyDown(event) {
      switch (event.key) {
        case " " /* Space */:
        case "Enter" /* Enter */:
        case "ArrowDown" /* ArrowDown */:
          event.preventDefault();
          api.openListbox();
          (0, import_vue16.nextTick)(() => {
            var _a;
            (_a = dom(api.optionsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
            if (!api.value.value)
              api.goToOption(0 /* First */);
          });
          break;
        case "ArrowUp" /* ArrowUp */:
          event.preventDefault();
          api.openListbox();
          (0, import_vue16.nextTick)(() => {
            var _a;
            (_a = dom(api.optionsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
            if (!api.value.value)
              api.goToOption(3 /* Last */);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case " " /* Space */:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (api.disabled.value)
        return;
      if (api.listboxState.value === 0 /* Open */) {
        api.closeListbox();
        (0, import_vue16.nextTick)(() => {
          var _a;
          return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
        });
      } else {
        event.preventDefault();
        api.openListbox();
        nextFrame(() => {
          var _a;
          return (_a = dom(api.optionsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
        });
      }
    }
    let type = useResolveButtonType((0, import_vue16.computed)(() => ({ as: props.as, type: attrs.type })), api.buttonRef);
    return () => {
      var _a, _b;
      let slot = {
        open: api.listboxState.value === 0 /* Open */,
        disabled: api.disabled.value
      };
      let propsWeControl = {
        ref: api.buttonRef,
        id: id2,
        type: type.value,
        "aria-haspopup": true,
        "aria-controls": (_a = dom(api.optionsRef)) == null ? void 0 : _a.id,
        "aria-expanded": api.disabled.value ? void 0 : api.listboxState.value === 0 /* Open */,
        "aria-labelledby": api.labelRef.value ? [(_b = dom(api.labelRef)) == null ? void 0 : _b.id, id2].join(" ") : void 0,
        disabled: api.disabled.value === true ? true : void 0,
        onKeydown: handleKeyDown,
        onKeyup: handleKeyUp,
        onClick: handleClick
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ListboxButton"
      });
    };
  }
});
var ListboxOptions = (0, import_vue16.defineComponent)({
  name: "ListboxOptions",
  props: {
    as: { type: [Object, String], default: "ul" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true }
  },
  setup(props, { attrs, slots }) {
    let api = useListboxContext("ListboxOptions");
    let id2 = `headlessui-listbox-options-${useId()}`;
    let searchDebounce = (0, import_vue16.ref)(null);
    function handleKeyDown(event) {
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case " " /* Space */:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case "Enter" /* Enter */:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeOptionIndex.value !== null) {
            let { dataRef } = api.options.value[api.activeOptionIndex.value];
            api.select(dataRef.value);
          }
          api.closeListbox();
          (0, import_vue16.nextTick)(() => {
            var _a;
            return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
          });
          break;
        case match(api.orientation.value, {
          vertical: "ArrowDown" /* ArrowDown */,
          horizontal: "ArrowRight" /* ArrowRight */
        }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(2 /* Next */);
        case match(api.orientation.value, { vertical: "ArrowUp" /* ArrowUp */, horizontal: "ArrowLeft" /* ArrowLeft */ }):
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(1 /* Previous */);
        case "Home" /* Home */:
        case "PageUp" /* PageUp */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(0 /* First */);
        case "End" /* End */:
        case "PageDown" /* PageDown */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToOption(3 /* Last */);
        case "Escape" /* Escape */:
          event.preventDefault();
          event.stopPropagation();
          api.closeListbox();
          (0, import_vue16.nextTick)(() => {
            var _a;
            return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
          });
          break;
        case "Tab" /* Tab */:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(() => api.clearSearch(), 350);
          }
          break;
      }
    }
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue16.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.listboxState.value === 0 /* Open */;
    });
    return () => {
      var _a, _b, _c, _d;
      let slot = { open: api.listboxState.value === 0 /* Open */ };
      let propsWeControl = {
        "aria-activedescendant": api.activeOptionIndex.value === null ? void 0 : (_a = api.options.value[api.activeOptionIndex.value]) == null ? void 0 : _a.id,
        "aria-labelledby": (_d = (_b = dom(api.labelRef)) == null ? void 0 : _b.id) != null ? _d : (_c = dom(api.buttonRef)) == null ? void 0 : _c.id,
        "aria-orientation": api.orientation.value,
        id: id2,
        onKeydown: handleKeyDown,
        role: "listbox",
        tabIndex: 0,
        ref: api.optionsRef
      };
      let passThroughProps = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "ListboxOptions"
      });
    };
  }
});
var ListboxOption = (0, import_vue16.defineComponent)({
  name: "ListboxOption",
  props: {
    as: { type: [Object, String], default: "li" },
    value: { type: [Object, String, Number, Boolean] },
    disabled: { type: Boolean, default: false }
  },
  setup(props, { slots, attrs }) {
    let api = useListboxContext("ListboxOption");
    let id2 = `headlessui-listbox-option-${useId()}`;
    let active = (0, import_vue16.computed)(() => {
      return api.activeOptionIndex.value !== null ? api.options.value[api.activeOptionIndex.value].id === id2 : false;
    });
    let selected = (0, import_vue16.computed)(() => (0, import_vue16.toRaw)(api.value.value) === (0, import_vue16.toRaw)(props.value));
    let dataRef = (0, import_vue16.ref)({
      disabled: props.disabled,
      value: props.value,
      textValue: ""
    });
    (0, import_vue16.onMounted)(() => {
      var _a, _b;
      let textValue = (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.textContent) == null ? void 0 : _b.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    (0, import_vue16.onMounted)(() => api.registerOption(id2, dataRef));
    (0, import_vue16.onUnmounted)(() => api.unregisterOption(id2));
    (0, import_vue16.onMounted)(() => {
      (0, import_vue16.watch)([api.listboxState, selected], () => {
        var _a, _b;
        if (api.listboxState.value !== 0 /* Open */)
          return;
        if (!selected.value)
          return;
        api.goToOption(4 /* Specific */, id2);
        (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.focus) == null ? void 0 : _b.call(_a);
      }, { immediate: true });
    });
    (0, import_vue16.watchEffect)(() => {
      if (api.listboxState.value !== 0 /* Open */)
        return;
      if (!active.value)
        return;
      (0, import_vue16.nextTick)(() => {
        var _a, _b;
        return (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.scrollIntoView) == null ? void 0 : _b.call(_a, { block: "nearest" });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.select(props.value);
      api.closeListbox();
      (0, import_vue16.nextTick)(() => {
        var _a;
        return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToOption(5 /* Nothing */);
      api.goToOption(4 /* Specific */, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToOption(4 /* Specific */, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToOption(5 /* Nothing */);
    }
    return () => {
      let { disabled } = props;
      let slot = { active: active.value, selected: selected.value, disabled };
      let propsWeControl = {
        id: id2,
        role: "option",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        "aria-selected": selected.value === true ? selected.value : void 0,
        disabled: void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "ListboxOption"
      });
    };
  }
});

// src/components/menu/menu.ts
var import_vue17 = require("vue");
function nextFrame2(cb) {
  requestAnimationFrame(() => requestAnimationFrame(cb));
}
var MenuContext = Symbol("MenuContext");
function useMenuContext(component) {
  let context = (0, import_vue17.inject)(MenuContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <Menu /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useMenuContext);
    throw err;
  }
  return context;
}
var Menu = (0, import_vue17.defineComponent)({
  name: "Menu",
  props: { as: { type: [Object, String], default: "template" } },
  setup(props, { slots, attrs }) {
    let menuState = (0, import_vue17.ref)(1 /* Closed */);
    let buttonRef = (0, import_vue17.ref)(null);
    let itemsRef = (0, import_vue17.ref)(null);
    let items = (0, import_vue17.ref)([]);
    let searchQuery = (0, import_vue17.ref)("");
    let activeItemIndex = (0, import_vue17.ref)(null);
    let api = {
      menuState,
      buttonRef,
      itemsRef,
      items,
      searchQuery,
      activeItemIndex,
      closeMenu: () => {
        menuState.value = 1 /* Closed */;
        activeItemIndex.value = null;
      },
      openMenu: () => menuState.value = 0 /* Open */,
      goToItem(focus, id2) {
        let nextActiveItemIndex = calculateActiveIndex(focus === 4 /* Specific */ ? { focus: 4 /* Specific */, id: id2 } : { focus }, {
          resolveItems: () => items.value,
          resolveActiveIndex: () => activeItemIndex.value,
          resolveId: (item) => item.id,
          resolveDisabled: (item) => item.dataRef.disabled
        });
        if (searchQuery.value === "" && activeItemIndex.value === nextActiveItemIndex)
          return;
        searchQuery.value = "";
        activeItemIndex.value = nextActiveItemIndex;
      },
      search(value) {
        let wasAlreadySearching = searchQuery.value !== "";
        let offset = wasAlreadySearching ? 0 : 1;
        searchQuery.value += value.toLowerCase();
        let reOrderedItems = activeItemIndex.value !== null ? items.value.slice(activeItemIndex.value + offset).concat(items.value.slice(0, activeItemIndex.value + offset)) : items.value;
        let matchingItem = reOrderedItems.find((item) => item.dataRef.textValue.startsWith(searchQuery.value) && !item.dataRef.disabled);
        let matchIdx = matchingItem ? items.value.indexOf(matchingItem) : -1;
        if (matchIdx === -1 || matchIdx === activeItemIndex.value)
          return;
        activeItemIndex.value = matchIdx;
      },
      clearSearch() {
        searchQuery.value = "";
      },
      registerItem(id2, dataRef) {
        var _a, _b;
        let orderMap = Array.from((_b = (_a = itemsRef.value) == null ? void 0 : _a.querySelectorAll('[id^="headlessui-menu-item-"]')) != null ? _b : []).reduce((lookup, element, index) => Object.assign(lookup, { [element.id]: index }), {});
        items.value = [...items.value, { id: id2, dataRef }].sort((a, z) => orderMap[a.id] - orderMap[z.id]);
      },
      unregisterItem(id2) {
        let nextItems = items.value.slice();
        let currentActiveItem = activeItemIndex.value !== null ? nextItems[activeItemIndex.value] : null;
        let idx = nextItems.findIndex((a) => a.id === id2);
        if (idx !== -1)
          nextItems.splice(idx, 1);
        items.value = nextItems;
        activeItemIndex.value = (() => {
          if (idx === activeItemIndex.value)
            return null;
          if (currentActiveItem === null)
            return null;
          return nextItems.indexOf(currentActiveItem);
        })();
      }
    };
    useWindowEvent("mousedown", (event) => {
      var _a, _b, _c;
      let target = event.target;
      let active = document.activeElement;
      if (menuState.value !== 0 /* Open */)
        return;
      if ((_a = dom(buttonRef)) == null ? void 0 : _a.contains(target))
        return;
      if (!((_b = dom(itemsRef)) == null ? void 0 : _b.contains(target)))
        api.closeMenu();
      if (active !== document.body && (active == null ? void 0 : active.contains(target)))
        return;
      if (!event.defaultPrevented)
        (_c = dom(buttonRef)) == null ? void 0 : _c.focus({ preventScroll: true });
    });
    (0, import_vue17.provide)(MenuContext, api);
    useOpenClosedProvider((0, import_vue17.computed)(() => match(menuState.value, {
      [0 /* Open */]: 0 /* Open */,
      [1 /* Closed */]: 1 /* Closed */
    })));
    return () => {
      let slot = { open: menuState.value === 0 /* Open */ };
      return render({ props, slot, slots, attrs, name: "Menu" });
    };
  }
});
var MenuButton = (0, import_vue17.defineComponent)({
  name: "MenuButton",
  props: {
    disabled: { type: Boolean, default: false },
    as: { type: [Object, String], default: "button" }
  },
  setup(props, { attrs, slots }) {
    let api = useMenuContext("MenuButton");
    let id2 = `headlessui-menu-button-${useId()}`;
    function handleKeyDown(event) {
      switch (event.key) {
        case " " /* Space */:
        case "Enter" /* Enter */:
        case "ArrowDown" /* ArrowDown */:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          (0, import_vue17.nextTick)(() => {
            var _a;
            (_a = dom(api.itemsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
            api.goToItem(0 /* First */);
          });
          break;
        case "ArrowUp" /* ArrowUp */:
          event.preventDefault();
          event.stopPropagation();
          api.openMenu();
          (0, import_vue17.nextTick)(() => {
            var _a;
            (_a = dom(api.itemsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
            api.goToItem(3 /* Last */);
          });
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case " " /* Space */:
          event.preventDefault();
          break;
      }
    }
    function handleClick(event) {
      if (props.disabled)
        return;
      if (api.menuState.value === 0 /* Open */) {
        api.closeMenu();
        (0, import_vue17.nextTick)(() => {
          var _a;
          return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
        });
      } else {
        event.preventDefault();
        event.stopPropagation();
        api.openMenu();
        nextFrame2(() => {
          var _a;
          return (_a = dom(api.itemsRef)) == null ? void 0 : _a.focus({ preventScroll: true });
        });
      }
    }
    let type = useResolveButtonType((0, import_vue17.computed)(() => ({ as: props.as, type: attrs.type })), api.buttonRef);
    return () => {
      var _a;
      let slot = { open: api.menuState.value === 0 /* Open */ };
      let propsWeControl = {
        ref: api.buttonRef,
        id: id2,
        type: type.value,
        "aria-haspopup": true,
        "aria-controls": (_a = dom(api.itemsRef)) == null ? void 0 : _a.id,
        "aria-expanded": props.disabled ? void 0 : api.menuState.value === 0 /* Open */,
        onKeydown: handleKeyDown,
        onKeyup: handleKeyUp,
        onClick: handleClick
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "MenuButton"
      });
    };
  }
});
var MenuItems = (0, import_vue17.defineComponent)({
  name: "MenuItems",
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true }
  },
  setup(props, { attrs, slots }) {
    let api = useMenuContext("MenuItems");
    let id2 = `headlessui-menu-items-${useId()}`;
    let searchDebounce = (0, import_vue17.ref)(null);
    useTreeWalker({
      container: (0, import_vue17.computed)(() => dom(api.itemsRef)),
      enabled: (0, import_vue17.computed)(() => api.menuState.value === 0 /* Open */),
      accept(node) {
        if (node.getAttribute("role") === "menuitem")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk(node) {
        node.setAttribute("role", "none");
      }
    });
    function handleKeyDown(event) {
      var _a;
      if (searchDebounce.value)
        clearTimeout(searchDebounce.value);
      switch (event.key) {
        case " " /* Space */:
          if (api.searchQuery.value !== "") {
            event.preventDefault();
            event.stopPropagation();
            return api.search(event.key);
          }
        case "Enter" /* Enter */:
          event.preventDefault();
          event.stopPropagation();
          if (api.activeItemIndex.value !== null) {
            let { id: id3 } = api.items.value[api.activeItemIndex.value];
            (_a = document.getElementById(id3)) == null ? void 0 : _a.click();
          }
          api.closeMenu();
          (0, import_vue17.nextTick)(() => {
            var _a2;
            return (_a2 = dom(api.buttonRef)) == null ? void 0 : _a2.focus({ preventScroll: true });
          });
          break;
        case "ArrowDown" /* ArrowDown */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(2 /* Next */);
        case "ArrowUp" /* ArrowUp */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(1 /* Previous */);
        case "Home" /* Home */:
        case "PageUp" /* PageUp */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(0 /* First */);
        case "End" /* End */:
        case "PageDown" /* PageDown */:
          event.preventDefault();
          event.stopPropagation();
          return api.goToItem(3 /* Last */);
        case "Escape" /* Escape */:
          event.preventDefault();
          event.stopPropagation();
          api.closeMenu();
          (0, import_vue17.nextTick)(() => {
            var _a2;
            return (_a2 = dom(api.buttonRef)) == null ? void 0 : _a2.focus({ preventScroll: true });
          });
          break;
        case "Tab" /* Tab */:
          event.preventDefault();
          event.stopPropagation();
          break;
        default:
          if (event.key.length === 1) {
            api.search(event.key);
            searchDebounce.value = setTimeout(() => api.clearSearch(), 350);
          }
          break;
      }
    }
    function handleKeyUp(event) {
      switch (event.key) {
        case " " /* Space */:
          event.preventDefault();
          break;
      }
    }
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue17.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.menuState.value === 0 /* Open */;
    });
    return () => {
      var _a, _b;
      let slot = { open: api.menuState.value === 0 /* Open */ };
      let propsWeControl = {
        "aria-activedescendant": api.activeItemIndex.value === null ? void 0 : (_a = api.items.value[api.activeItemIndex.value]) == null ? void 0 : _a.id,
        "aria-labelledby": (_b = dom(api.buttonRef)) == null ? void 0 : _b.id,
        id: id2,
        onKeydown: handleKeyDown,
        onKeyup: handleKeyUp,
        role: "menu",
        tabIndex: 0,
        ref: api.itemsRef
      };
      let passThroughProps = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "MenuItems"
      });
    };
  }
});
var MenuItem = (0, import_vue17.defineComponent)({
  name: "MenuItem",
  props: {
    as: { type: [Object, String], default: "template" },
    disabled: { type: Boolean, default: false }
  },
  setup(props, { slots, attrs }) {
    let api = useMenuContext("MenuItem");
    let id2 = `headlessui-menu-item-${useId()}`;
    let active = (0, import_vue17.computed)(() => {
      return api.activeItemIndex.value !== null ? api.items.value[api.activeItemIndex.value].id === id2 : false;
    });
    let dataRef = (0, import_vue17.ref)({ disabled: props.disabled, textValue: "" });
    (0, import_vue17.onMounted)(() => {
      var _a, _b;
      let textValue = (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.textContent) == null ? void 0 : _b.toLowerCase().trim();
      if (textValue !== void 0)
        dataRef.value.textValue = textValue;
    });
    (0, import_vue17.onMounted)(() => api.registerItem(id2, dataRef));
    (0, import_vue17.onUnmounted)(() => api.unregisterItem(id2));
    (0, import_vue17.watchEffect)(() => {
      if (api.menuState.value !== 0 /* Open */)
        return;
      if (!active.value)
        return;
      (0, import_vue17.nextTick)(() => {
        var _a, _b;
        return (_b = (_a = document.getElementById(id2)) == null ? void 0 : _a.scrollIntoView) == null ? void 0 : _b.call(_a, { block: "nearest" });
      });
    });
    function handleClick(event) {
      if (props.disabled)
        return event.preventDefault();
      api.closeMenu();
      (0, import_vue17.nextTick)(() => {
        var _a;
        return (_a = dom(api.buttonRef)) == null ? void 0 : _a.focus({ preventScroll: true });
      });
    }
    function handleFocus() {
      if (props.disabled)
        return api.goToItem(5 /* Nothing */);
      api.goToItem(4 /* Specific */, id2);
    }
    function handleMove() {
      if (props.disabled)
        return;
      if (active.value)
        return;
      api.goToItem(4 /* Specific */, id2);
    }
    function handleLeave() {
      if (props.disabled)
        return;
      if (!active.value)
        return;
      api.goToItem(5 /* Nothing */);
    }
    return () => {
      let { disabled } = props;
      let slot = { active: active.value, disabled };
      let propsWeControl = {
        id: id2,
        role: "menuitem",
        tabIndex: disabled === true ? void 0 : -1,
        "aria-disabled": disabled === true ? true : void 0,
        onClick: handleClick,
        onFocus: handleFocus,
        onPointermove: handleMove,
        onMousemove: handleMove,
        onPointerleave: handleLeave,
        onMouseleave: handleLeave
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "MenuItem"
      });
    };
  }
});

// src/components/popover/popover.ts
var import_vue18 = require("vue");
var PopoverContext = Symbol("PopoverContext");
function usePopoverContext(component) {
  let context = (0, import_vue18.inject)(PopoverContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <${Popover.name} /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, usePopoverContext);
    throw err;
  }
  return context;
}
var PopoverGroupContext = Symbol("PopoverGroupContext");
function usePopoverGroupContext() {
  return (0, import_vue18.inject)(PopoverGroupContext, null);
}
var PopoverPanelContext = Symbol("PopoverPanelContext");
function usePopoverPanelContext() {
  return (0, import_vue18.inject)(PopoverPanelContext, null);
}
var Popover = (0, import_vue18.defineComponent)({
  name: "Popover",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { slots, attrs }) {
    let buttonId = `headlessui-popover-button-${useId()}`;
    let panelId = `headlessui-popover-panel-${useId()}`;
    let popoverState = (0, import_vue18.ref)(1 /* Closed */);
    let button = (0, import_vue18.ref)(null);
    let panel = (0, import_vue18.ref)(null);
    let api = {
      popoverState,
      buttonId,
      panelId,
      panel,
      button,
      togglePopover() {
        popoverState.value = match(popoverState.value, {
          [0 /* Open */]: 1 /* Closed */,
          [1 /* Closed */]: 0 /* Open */
        });
      },
      closePopover() {
        if (popoverState.value === 1 /* Closed */)
          return;
        popoverState.value = 1 /* Closed */;
      },
      close(focusableElement) {
        api.closePopover();
        let restoreElement = (() => {
          if (!focusableElement)
            return dom(api.button);
          if (focusableElement instanceof HTMLElement)
            return focusableElement;
          if (focusableElement.value instanceof HTMLElement)
            return dom(focusableElement);
          return dom(api.button);
        })();
        restoreElement == null ? void 0 : restoreElement.focus();
      }
    };
    (0, import_vue18.provide)(PopoverContext, api);
    useOpenClosedProvider((0, import_vue18.computed)(() => match(popoverState.value, {
      [0 /* Open */]: 0 /* Open */,
      [1 /* Closed */]: 1 /* Closed */
    })));
    let registerBag = {
      buttonId,
      panelId,
      close() {
        api.closePopover();
      }
    };
    let groupContext = usePopoverGroupContext();
    let registerPopover = groupContext == null ? void 0 : groupContext.registerPopover;
    function isFocusWithinPopoverGroup() {
      var _a, _b, _c;
      return (_c = groupContext == null ? void 0 : groupContext.isFocusWithinPopoverGroup()) != null ? _c : ((_a = dom(button)) == null ? void 0 : _a.contains(document.activeElement)) || ((_b = dom(panel)) == null ? void 0 : _b.contains(document.activeElement));
    }
    (0, import_vue18.watchEffect)(() => registerPopover == null ? void 0 : registerPopover(registerBag));
    useWindowEvent("focus", () => {
      if (popoverState.value !== 0 /* Open */)
        return;
      if (isFocusWithinPopoverGroup())
        return;
      if (!button)
        return;
      if (!panel)
        return;
      api.closePopover();
    }, true);
    useWindowEvent("mousedown", (event) => {
      var _a, _b, _c;
      let target = event.target;
      if (popoverState.value !== 0 /* Open */)
        return;
      if ((_a = dom(button)) == null ? void 0 : _a.contains(target))
        return;
      if ((_b = dom(panel)) == null ? void 0 : _b.contains(target))
        return;
      api.closePopover();
      if (!isFocusableElement(target, 1 /* Loose */)) {
        event.preventDefault();
        (_c = dom(button)) == null ? void 0 : _c.focus();
      }
    });
    return () => {
      let slot = { open: popoverState.value === 0 /* Open */, close: api.close };
      return render({ props, slot, slots, attrs, name: "Popover" });
    };
  }
});
var PopoverButton = (0, import_vue18.defineComponent)({
  name: "PopoverButton",
  props: {
    as: { type: [Object, String], default: "button" },
    disabled: { type: [Boolean], default: false }
  },
  setup(props, { attrs, slots }) {
    let api = usePopoverContext("PopoverButton");
    let groupContext = usePopoverGroupContext();
    let closeOthers = groupContext == null ? void 0 : groupContext.closeOthers;
    let panelContext = usePopoverPanelContext();
    let isWithinPanel = panelContext === null ? false : panelContext === api.panelId;
    let activeElementRef = (0, import_vue18.ref)(null);
    let previousActiveElementRef = (0, import_vue18.ref)(typeof window === "undefined" ? null : document.activeElement);
    useWindowEvent("focus", () => {
      previousActiveElementRef.value = activeElementRef.value;
      activeElementRef.value = document.activeElement;
    }, true);
    let elementRef = (0, import_vue18.ref)(null);
    if (!isWithinPanel) {
      (0, import_vue18.watchEffect)(() => {
        api.button.value = elementRef.value;
      });
    }
    let type = useResolveButtonType((0, import_vue18.computed)(() => ({ as: props.as, type: attrs.type })), elementRef);
    function handleKeyDown(event) {
      var _a, _b, _c, _d;
      if (isWithinPanel) {
        if (api.popoverState.value === 1 /* Closed */)
          return;
        switch (event.key) {
          case " " /* Space */:
          case "Enter" /* Enter */:
            event.preventDefault();
            event.stopPropagation();
            api.closePopover();
            (_a = dom(api.button)) == null ? void 0 : _a.focus();
            break;
        }
      } else {
        switch (event.key) {
          case " " /* Space */:
          case "Enter" /* Enter */:
            event.preventDefault();
            event.stopPropagation();
            if (api.popoverState.value === 1 /* Closed */)
              closeOthers == null ? void 0 : closeOthers(api.buttonId);
            api.togglePopover();
            break;
          case "Escape" /* Escape */:
            if (api.popoverState.value !== 0 /* Open */)
              return closeOthers == null ? void 0 : closeOthers(api.buttonId);
            if (!dom(api.button))
              return;
            if (!((_b = dom(api.button)) == null ? void 0 : _b.contains(document.activeElement)))
              return;
            event.preventDefault();
            event.stopPropagation();
            api.closePopover();
            break;
          case "Tab" /* Tab */:
            if (api.popoverState.value !== 0 /* Open */)
              return;
            if (!api.panel)
              return;
            if (!api.button)
              return;
            if (event.shiftKey) {
              if (!previousActiveElementRef.value)
                return;
              if ((_c = dom(api.button)) == null ? void 0 : _c.contains(previousActiveElementRef.value))
                return;
              if ((_d = dom(api.panel)) == null ? void 0 : _d.contains(previousActiveElementRef.value))
                return;
              let focusableElements = getFocusableElements();
              let previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
              let buttonIdx = focusableElements.indexOf(dom(api.button));
              if (buttonIdx > previousIdx)
                return;
              event.preventDefault();
              event.stopPropagation();
              focusIn(dom(api.panel), 8 /* Last */);
            } else {
              event.preventDefault();
              event.stopPropagation();
              focusIn(dom(api.panel), 1 /* First */);
            }
            break;
        }
      }
    }
    function handleKeyUp(event) {
      var _a, _b;
      if (isWithinPanel)
        return;
      if (event.key === " " /* Space */) {
        event.preventDefault();
      }
      if (api.popoverState.value !== 0 /* Open */)
        return;
      if (!api.panel)
        return;
      if (!api.button)
        return;
      switch (event.key) {
        case "Tab" /* Tab */:
          if (!previousActiveElementRef.value)
            return;
          if ((_a = dom(api.button)) == null ? void 0 : _a.contains(previousActiveElementRef.value))
            return;
          if ((_b = dom(api.panel)) == null ? void 0 : _b.contains(previousActiveElementRef.value))
            return;
          let focusableElements = getFocusableElements();
          let previousIdx = focusableElements.indexOf(previousActiveElementRef.value);
          let buttonIdx = focusableElements.indexOf(dom(api.button));
          if (buttonIdx > previousIdx)
            return;
          event.preventDefault();
          event.stopPropagation();
          focusIn(dom(api.panel), 8 /* Last */);
          break;
      }
    }
    function handleClick() {
      var _a, _b;
      if (props.disabled)
        return;
      if (isWithinPanel) {
        api.closePopover();
        (_a = dom(api.button)) == null ? void 0 : _a.focus();
      } else {
        if (api.popoverState.value === 1 /* Closed */)
          closeOthers == null ? void 0 : closeOthers(api.buttonId);
        (_b = dom(api.button)) == null ? void 0 : _b.focus();
        api.togglePopover();
      }
    }
    return () => {
      let slot = { open: api.popoverState.value === 0 /* Open */ };
      let propsWeControl = isWithinPanel ? {
        ref: elementRef,
        type: type.value,
        onKeydown: handleKeyDown,
        onClick: handleClick
      } : {
        ref: elementRef,
        id: api.buttonId,
        type: type.value,
        "aria-expanded": props.disabled ? void 0 : api.popoverState.value === 0 /* Open */,
        "aria-controls": dom(api.panel) ? api.panelId : void 0,
        disabled: props.disabled ? true : void 0,
        onKeydown: handleKeyDown,
        onKeyup: handleKeyUp,
        onClick: handleClick
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "PopoverButton"
      });
    };
  }
});
var PopoverOverlay = (0, import_vue18.defineComponent)({
  name: "PopoverOverlay",
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true }
  },
  setup(props, { attrs, slots }) {
    let api = usePopoverContext("PopoverOverlay");
    let id2 = `headlessui-popover-overlay-${useId()}`;
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue18.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.popoverState.value === 0 /* Open */;
    });
    function handleClick() {
      api.closePopover();
    }
    return () => {
      let slot = { open: api.popoverState.value === 0 /* Open */ };
      let propsWeControl = {
        id: id2,
        "aria-hidden": true,
        onClick: handleClick
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "PopoverOverlay"
      });
    };
  }
});
var PopoverPanel = (0, import_vue18.defineComponent)({
  name: "PopoverPanel",
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true },
    focus: { type: Boolean, default: false }
  },
  setup(props, { attrs, slots }) {
    let { focus } = props;
    let api = usePopoverContext("PopoverPanel");
    (0, import_vue18.provide)(PopoverPanelContext, api.panelId);
    (0, import_vue18.onUnmounted)(() => {
      api.panel.value = null;
    });
    (0, import_vue18.watchEffect)(() => {
      var _a;
      if (!focus)
        return;
      if (api.popoverState.value !== 0 /* Open */)
        return;
      if (!api.panel)
        return;
      let activeElement = document.activeElement;
      if ((_a = dom(api.panel)) == null ? void 0 : _a.contains(activeElement))
        return;
      focusIn(dom(api.panel), 1 /* First */);
    });
    useWindowEvent("keydown", (event) => {
      var _a, _b;
      if (api.popoverState.value !== 0 /* Open */)
        return;
      if (!dom(api.panel))
        return;
      if (event.key !== "Tab" /* Tab */)
        return;
      if (!document.activeElement)
        return;
      if (!((_a = dom(api.panel)) == null ? void 0 : _a.contains(document.activeElement)))
        return;
      event.preventDefault();
      let result = focusIn(dom(api.panel), event.shiftKey ? 2 /* Previous */ : 4 /* Next */);
      if (result === 3 /* Underflow */) {
        return (_b = dom(api.button)) == null ? void 0 : _b.focus();
      } else if (result === 1 /* Overflow */) {
        if (!dom(api.button))
          return;
        let elements = getFocusableElements();
        let buttonIdx = elements.indexOf(dom(api.button));
        let nextElements = elements.splice(buttonIdx + 1).filter((element) => {
          var _a2;
          return !((_a2 = dom(api.panel)) == null ? void 0 : _a2.contains(element));
        });
        if (focusIn(nextElements, 1 /* First */) === 0 /* Error */) {
          focusIn(document.body, 1 /* First */);
        }
      }
    });
    useWindowEvent("focus", () => {
      var _a;
      if (!focus)
        return;
      if (api.popoverState.value !== 0 /* Open */)
        return;
      if (!dom(api.panel))
        return;
      if ((_a = dom(api.panel)) == null ? void 0 : _a.contains(document.activeElement))
        return;
      api.closePopover();
    }, true);
    let usesOpenClosedState = useOpenClosed();
    let visible = (0, import_vue18.computed)(() => {
      if (usesOpenClosedState !== null) {
        return usesOpenClosedState.value === 0 /* Open */;
      }
      return api.popoverState.value === 0 /* Open */;
    });
    function handleKeyDown(event) {
      var _a, _b;
      switch (event.key) {
        case "Escape" /* Escape */:
          if (api.popoverState.value !== 0 /* Open */)
            return;
          if (!dom(api.panel))
            return;
          if (!((_a = dom(api.panel)) == null ? void 0 : _a.contains(document.activeElement)))
            return;
          event.preventDefault();
          event.stopPropagation();
          api.closePopover();
          (_b = dom(api.button)) == null ? void 0 : _b.focus();
          break;
      }
    }
    return () => {
      let slot = {
        open: api.popoverState.value === 0 /* Open */,
        close: api.close
      };
      let propsWeControl = {
        ref: api.panel,
        id: api.panelId,
        onKeydown: handleKeyDown
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 1 /* RenderStrategy */ | 2 /* Static */,
        visible: visible.value,
        name: "PopoverPanel"
      });
    };
  }
});
var PopoverGroup = (0, import_vue18.defineComponent)({
  name: "PopoverGroup",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { attrs, slots }) {
    let groupRef = (0, import_vue18.ref)(null);
    let popovers = (0, import_vue18.ref)([]);
    function unregisterPopover(registerBag) {
      let idx = popovers.value.indexOf(registerBag);
      if (idx !== -1)
        popovers.value.splice(idx, 1);
    }
    function registerPopover(registerBag) {
      popovers.value.push(registerBag);
      return () => {
        unregisterPopover(registerBag);
      };
    }
    function isFocusWithinPopoverGroup() {
      var _a;
      let element = document.activeElement;
      if ((_a = dom(groupRef)) == null ? void 0 : _a.contains(element))
        return true;
      return popovers.value.some((bag) => {
        var _a2, _b;
        return ((_a2 = document.getElementById(bag.buttonId)) == null ? void 0 : _a2.contains(element)) || ((_b = document.getElementById(bag.panelId)) == null ? void 0 : _b.contains(element));
      });
    }
    function closeOthers(buttonId) {
      for (let popover of popovers.value) {
        if (popover.buttonId !== buttonId)
          popover.close();
      }
    }
    (0, import_vue18.provide)(PopoverGroupContext, {
      registerPopover,
      unregisterPopover,
      isFocusWithinPopoverGroup,
      closeOthers
    });
    return () => {
      let propsWeControl = { ref: groupRef };
      return render({
        props: { ...props, ...propsWeControl },
        slot: {},
        attrs,
        slots,
        name: "PopoverGroup"
      });
    };
  }
});

// src/components/radio-group/radio-group.ts
var import_vue20 = require("vue");

// src/components/label/label.ts
var import_vue19 = require("vue");
var LabelContext = Symbol("LabelContext");
function useLabelContext() {
  let context = (0, import_vue19.inject)(LabelContext, null);
  if (context === null) {
    let err = new Error("You used a <Label /> component, but it is not inside a parent.");
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useLabelContext);
    throw err;
  }
  return context;
}
function useLabels({
  slot = {},
  name = "Label",
  props = {}
} = {}) {
  let labelIds = (0, import_vue19.ref)([]);
  function register(value) {
    labelIds.value.push(value);
    return () => {
      let idx = labelIds.value.indexOf(value);
      if (idx === -1)
        return;
      labelIds.value.splice(idx, 1);
    };
  }
  (0, import_vue19.provide)(LabelContext, { register, slot, name, props });
  return (0, import_vue19.computed)(() => labelIds.value.length > 0 ? labelIds.value.join(" ") : void 0);
}
var Label = (0, import_vue19.defineComponent)({
  name: "Label",
  props: {
    as: { type: [Object, String], default: "label" },
    passive: { type: [Boolean], default: false }
  },
  setup(myProps, { slots, attrs }) {
    let context = useLabelContext();
    let id2 = `headlessui-label-${useId()}`;
    (0, import_vue19.onMounted)(() => (0, import_vue19.onUnmounted)(context.register(id2)));
    return () => {
      let { name = "Label", slot = {}, props = {} } = context;
      let { passive, ...passThroughProps } = myProps;
      let propsWeControl = {
        ...Object.entries(props).reduce((acc, [key, value]) => Object.assign(acc, { [key]: (0, import_vue19.unref)(value) }), {}),
        id: id2
      };
      let allProps = { ...passThroughProps, ...propsWeControl };
      if (passive)
        delete allProps["onClick"];
      return render({
        props: allProps,
        slot,
        attrs,
        slots,
        name
      });
    };
  }
});

// src/components/radio-group/radio-group.ts
var RadioGroupContext = Symbol("RadioGroupContext");
function useRadioGroupContext(component) {
  let context = (0, import_vue20.inject)(RadioGroupContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <RadioGroup /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useRadioGroupContext);
    throw err;
  }
  return context;
}
var RadioGroup = (0, import_vue20.defineComponent)({
  name: "RadioGroup",
  emits: { "update:modelValue": (_value) => true },
  props: {
    as: { type: [Object, String], default: "div" },
    disabled: { type: [Boolean], default: false },
    modelValue: { type: [Object, String, Number, Boolean] }
  },
  setup(props, { emit, attrs, slots }) {
    let radioGroupRef = (0, import_vue20.ref)(null);
    let options = (0, import_vue20.ref)([]);
    let labelledby = useLabels({ name: "RadioGroupLabel" });
    let describedby = useDescriptions({ name: "RadioGroupDescription" });
    let value = (0, import_vue20.computed)(() => props.modelValue);
    let api = {
      options,
      value,
      disabled: (0, import_vue20.computed)(() => props.disabled),
      firstOption: (0, import_vue20.computed)(() => options.value.find((option) => {
        if (option.propsRef.disabled)
          return false;
        return true;
      })),
      containsCheckedOption: (0, import_vue20.computed)(() => options.value.some((option) => (0, import_vue20.toRaw)(option.propsRef.value) === (0, import_vue20.toRaw)(props.modelValue))),
      change(nextValue) {
        var _a;
        if (props.disabled)
          return false;
        if (value.value === nextValue)
          return false;
        let nextOption = (_a = options.value.find((option) => (0, import_vue20.toRaw)(option.propsRef.value) === (0, import_vue20.toRaw)(nextValue))) == null ? void 0 : _a.propsRef;
        if (nextOption == null ? void 0 : nextOption.disabled)
          return false;
        emit("update:modelValue", nextValue);
        return true;
      },
      registerOption(action) {
        var _a;
        let orderMap = Array.from((_a = radioGroupRef.value) == null ? void 0 : _a.querySelectorAll('[id^="headlessui-radiogroup-option-"]')).reduce((lookup, element, index) => Object.assign(lookup, { [element.id]: index }), {});
        options.value.push(action);
        options.value.sort((a, z) => orderMap[a.id] - orderMap[z.id]);
      },
      unregisterOption(id3) {
        let idx = options.value.findIndex((radio) => radio.id === id3);
        if (idx === -1)
          return;
        options.value.splice(idx, 1);
      }
    };
    (0, import_vue20.provide)(RadioGroupContext, api);
    useTreeWalker({
      container: (0, import_vue20.computed)(() => dom(radioGroupRef)),
      accept(node) {
        if (node.getAttribute("role") === "radio")
          return NodeFilter.FILTER_REJECT;
        if (node.hasAttribute("role"))
          return NodeFilter.FILTER_SKIP;
        return NodeFilter.FILTER_ACCEPT;
      },
      walk(node) {
        node.setAttribute("role", "none");
      }
    });
    function handleKeyDown(event) {
      if (!radioGroupRef.value)
        return;
      if (!radioGroupRef.value.contains(event.target))
        return;
      let all = options.value.filter((option) => option.propsRef.disabled === false).map((radio) => radio.element);
      switch (event.key) {
        case "ArrowLeft" /* ArrowLeft */:
        case "ArrowUp" /* ArrowUp */:
          {
            event.preventDefault();
            event.stopPropagation();
            let result = focusIn(all, 2 /* Previous */ | 16 /* WrapAround */);
            if (result === 2 /* Success */) {
              let activeOption = options.value.find((option) => option.element === document.activeElement);
              if (activeOption)
                api.change(activeOption.propsRef.value);
            }
          }
          break;
        case "ArrowRight" /* ArrowRight */:
        case "ArrowDown" /* ArrowDown */:
          {
            event.preventDefault();
            event.stopPropagation();
            let result = focusIn(all, 4 /* Next */ | 16 /* WrapAround */);
            if (result === 2 /* Success */) {
              let activeOption = options.value.find((option) => option.element === document.activeElement);
              if (activeOption)
                api.change(activeOption.propsRef.value);
            }
          }
          break;
        case " " /* Space */:
          {
            event.preventDefault();
            event.stopPropagation();
            let activeOption = options.value.find((option) => option.element === document.activeElement);
            if (activeOption)
              api.change(activeOption.propsRef.value);
          }
          break;
      }
    }
    let id2 = `headlessui-radiogroup-${useId()}`;
    return () => {
      let { modelValue, disabled, ...passThroughProps } = props;
      let propsWeControl = {
        ref: radioGroupRef,
        id: id2,
        role: "radiogroup",
        "aria-labelledby": labelledby.value,
        "aria-describedby": describedby.value,
        onKeydown: handleKeyDown
      };
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot: {},
        attrs,
        slots,
        name: "RadioGroup"
      });
    };
  }
});
var RadioGroupOption = (0, import_vue20.defineComponent)({
  name: "RadioGroupOption",
  props: {
    as: { type: [Object, String], default: "div" },
    value: { type: [Object, String, Number, Boolean] },
    disabled: { type: Boolean, default: false }
  },
  setup(props, { attrs, slots }) {
    let api = useRadioGroupContext("RadioGroupOption");
    let id2 = `headlessui-radiogroup-option-${useId()}`;
    let labelledby = useLabels({ name: "RadioGroupLabel" });
    let describedby = useDescriptions({ name: "RadioGroupDescription" });
    let optionRef = (0, import_vue20.ref)(null);
    let propsRef = (0, import_vue20.computed)(() => ({ value: props.value, disabled: props.disabled }));
    let state = (0, import_vue20.ref)(1 /* Empty */);
    (0, import_vue20.onMounted)(() => api.registerOption({ id: id2, element: optionRef, propsRef }));
    (0, import_vue20.onUnmounted)(() => api.unregisterOption(id2));
    let isFirstOption = (0, import_vue20.computed)(() => {
      var _a;
      return ((_a = api.firstOption.value) == null ? void 0 : _a.id) === id2;
    });
    let disabled = (0, import_vue20.computed)(() => api.disabled.value || props.disabled);
    let checked = (0, import_vue20.computed)(() => (0, import_vue20.toRaw)(api.value.value) === (0, import_vue20.toRaw)(props.value));
    let tabIndex = (0, import_vue20.computed)(() => {
      if (disabled.value)
        return -1;
      if (checked.value)
        return 0;
      if (!api.containsCheckedOption.value && isFirstOption.value)
        return 0;
      return -1;
    });
    function handleClick() {
      var _a;
      if (!api.change(props.value))
        return;
      state.value |= 2 /* Active */;
      (_a = optionRef.value) == null ? void 0 : _a.focus();
    }
    function handleFocus() {
      state.value |= 2 /* Active */;
    }
    function handleBlur() {
      state.value &= ~2 /* Active */;
    }
    return () => {
      let passThroughProps = omit(props, ["value", "disabled"]);
      let slot = {
        checked: checked.value,
        disabled: disabled.value,
        active: Boolean(state.value & 2 /* Active */)
      };
      let propsWeControl = {
        id: id2,
        ref: optionRef,
        role: "radio",
        "aria-checked": checked.value ? "true" : "false",
        "aria-labelledby": labelledby.value,
        "aria-describedby": describedby.value,
        "aria-disabled": disabled.value ? true : void 0,
        tabIndex: tabIndex.value,
        onClick: disabled.value ? void 0 : handleClick,
        onFocus: disabled.value ? void 0 : handleFocus,
        onBlur: disabled.value ? void 0 : handleBlur
      };
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "RadioGroupOption"
      });
    };
  }
});
var RadioGroupLabel = Label;
var RadioGroupDescription = Description;

// src/components/switch/switch.ts
var import_vue21 = require("vue");
var GroupContext = Symbol("GroupContext");
var SwitchGroup = (0, import_vue21.defineComponent)({
  name: "SwitchGroup",
  props: {
    as: { type: [Object, String], default: "template" }
  },
  setup(props, { slots, attrs }) {
    let switchRef = (0, import_vue21.ref)(null);
    let labelledby = useLabels({
      name: "SwitchLabel",
      props: {
        onClick() {
          if (!switchRef.value)
            return;
          switchRef.value.click();
          switchRef.value.focus({ preventScroll: true });
        }
      }
    });
    let describedby = useDescriptions({ name: "SwitchDescription" });
    let api = { switchRef, labelledby, describedby };
    (0, import_vue21.provide)(GroupContext, api);
    return () => render({ props, slot: {}, slots, attrs, name: "SwitchGroup" });
  }
});
var Switch = (0, import_vue21.defineComponent)({
  name: "Switch",
  emits: { "update:modelValue": (_value) => true },
  props: {
    as: { type: [Object, String], default: "button" },
    modelValue: { type: Boolean, default: false }
  },
  setup(props, { emit, attrs, slots }) {
    let api = (0, import_vue21.inject)(GroupContext, null);
    let id2 = `headlessui-switch-${useId()}`;
    function toggle() {
      emit("update:modelValue", !props.modelValue);
    }
    let internalSwitchRef = (0, import_vue21.ref)(null);
    let switchRef = api === null ? internalSwitchRef : api.switchRef;
    let type = useResolveButtonType((0, import_vue21.computed)(() => ({ as: props.as, type: attrs.type })), switchRef);
    function handleClick(event) {
      event.preventDefault();
      toggle();
    }
    function handleKeyUp(event) {
      if (event.key !== "Tab" /* Tab */)
        event.preventDefault();
      if (event.key === " " /* Space */)
        toggle();
    }
    function handleKeyPress(event) {
      event.preventDefault();
    }
    return () => {
      let slot = { checked: props.modelValue };
      let propsWeControl = {
        id: id2,
        ref: switchRef,
        role: "switch",
        type: type.value,
        tabIndex: 0,
        "aria-checked": props.modelValue,
        "aria-labelledby": api == null ? void 0 : api.labelledby.value,
        "aria-describedby": api == null ? void 0 : api.describedby.value,
        onClick: handleClick,
        onKeyup: handleKeyUp,
        onKeypress: handleKeyPress
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "Switch"
      });
    };
  }
});
var SwitchLabel = Label;
var SwitchDescription = Description;

// src/components/tabs/tabs.ts
var import_vue22 = require("vue");
var TabsContext = Symbol("TabsContext");
function useTabsContext(component) {
  let context = (0, import_vue22.inject)(TabsContext, null);
  if (context === null) {
    let err = new Error(`<${component} /> is missing a parent <TabGroup /> component.`);
    if (Error.captureStackTrace)
      Error.captureStackTrace(err, useTabsContext);
    throw err;
  }
  return context;
}
var TabGroup = (0, import_vue22.defineComponent)({
  name: "TabGroup",
  emits: {
    change: (_index) => true
  },
  props: {
    as: { type: [Object, String], default: "template" },
    selectedIndex: { type: [Number], default: null },
    defaultIndex: { type: [Number], default: 0 },
    vertical: { type: [Boolean], default: false },
    manual: { type: [Boolean], default: false }
  },
  setup(props, { slots, attrs, emit }) {
    let selectedIndex = (0, import_vue22.ref)(null);
    let tabs = (0, import_vue22.ref)([]);
    let panels = (0, import_vue22.ref)([]);
    let api = {
      selectedIndex,
      orientation: (0, import_vue22.computed)(() => props.vertical ? "vertical" : "horizontal"),
      activation: (0, import_vue22.computed)(() => props.manual ? "manual" : "auto"),
      tabs,
      panels,
      setSelectedIndex(index) {
        if (selectedIndex.value === index)
          return;
        selectedIndex.value = index;
        emit("change", index);
      },
      registerTab(tab) {
        if (!tabs.value.includes(tab))
          tabs.value.push(tab);
      },
      unregisterTab(tab) {
        let idx = tabs.value.indexOf(tab);
        if (idx !== -1)
          tabs.value.splice(idx, 1);
      },
      registerPanel(panel) {
        if (!panels.value.includes(panel))
          panels.value.push(panel);
      },
      unregisterPanel(panel) {
        let idx = panels.value.indexOf(panel);
        if (idx !== -1)
          panels.value.splice(idx, 1);
      }
    };
    (0, import_vue22.provide)(TabsContext, api);
    (0, import_vue22.watchEffect)(() => {
      var _a;
      if (api.tabs.value.length <= 0)
        return;
      if (props.selectedIndex === null && selectedIndex.value !== null)
        return;
      let tabs2 = api.tabs.value.map((tab) => dom(tab)).filter(Boolean);
      let focusableTabs = tabs2.filter((tab) => !tab.hasAttribute("disabled"));
      let indexToSet = (_a = props.selectedIndex) != null ? _a : props.defaultIndex;
      if (indexToSet < 0) {
        selectedIndex.value = tabs2.indexOf(focusableTabs[0]);
      } else if (indexToSet > api.tabs.value.length) {
        selectedIndex.value = tabs2.indexOf(focusableTabs[focusableTabs.length - 1]);
      } else {
        let before = tabs2.slice(0, indexToSet);
        let after = tabs2.slice(indexToSet);
        let next = [...after, ...before].find((tab) => focusableTabs.includes(tab));
        if (!next)
          return;
        selectedIndex.value = tabs2.indexOf(next);
      }
    });
    return () => {
      let slot = { selectedIndex: selectedIndex.value };
      return render({
        props: omit(props, ["selectedIndex", "defaultIndex", "manual", "vertical", "onChange"]),
        slot,
        slots,
        attrs,
        name: "TabGroup"
      });
    };
  }
});
var TabList = (0, import_vue22.defineComponent)({
  name: "TabList",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { attrs, slots }) {
    let api = useTabsContext("TabList");
    return () => {
      let slot = { selectedIndex: api.selectedIndex.value };
      let propsWeControl = {
        role: "tablist",
        "aria-orientation": api.orientation.value
      };
      let passThroughProps = props;
      return render({
        props: { ...passThroughProps, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "TabList"
      });
    };
  }
});
var Tab = (0, import_vue22.defineComponent)({
  name: "Tab",
  props: {
    as: { type: [Object, String], default: "button" },
    disabled: { type: [Boolean], default: false }
  },
  setup(props, { attrs, slots }) {
    let api = useTabsContext("Tab");
    let id2 = `headlessui-tabs-tab-${useId()}`;
    let tabRef = (0, import_vue22.ref)();
    (0, import_vue22.onMounted)(() => api.registerTab(tabRef));
    (0, import_vue22.onUnmounted)(() => api.unregisterTab(tabRef));
    let myIndex = (0, import_vue22.computed)(() => api.tabs.value.indexOf(tabRef));
    let selected = (0, import_vue22.computed)(() => myIndex.value === api.selectedIndex.value);
    function handleKeyDown(event) {
      let list = api.tabs.value.map((tab) => dom(tab)).filter(Boolean);
      if (event.key === " " /* Space */ || event.key === "Enter" /* Enter */) {
        event.preventDefault();
        event.stopPropagation();
        api.setSelectedIndex(myIndex.value);
        return;
      }
      switch (event.key) {
        case "Home" /* Home */:
        case "PageUp" /* PageUp */:
          event.preventDefault();
          event.stopPropagation();
          return focusIn(list, 1 /* First */);
        case "End" /* End */:
        case "PageDown" /* PageDown */:
          event.preventDefault();
          event.stopPropagation();
          return focusIn(list, 8 /* Last */);
      }
      return match(api.orientation.value, {
        vertical() {
          if (event.key === "ArrowUp" /* ArrowUp */)
            return focusIn(list, 2 /* Previous */ | 16 /* WrapAround */);
          if (event.key === "ArrowDown" /* ArrowDown */)
            return focusIn(list, 4 /* Next */ | 16 /* WrapAround */);
          return;
        },
        horizontal() {
          if (event.key === "ArrowLeft" /* ArrowLeft */)
            return focusIn(list, 2 /* Previous */ | 16 /* WrapAround */);
          if (event.key === "ArrowRight" /* ArrowRight */)
            return focusIn(list, 4 /* Next */ | 16 /* WrapAround */);
          return;
        }
      });
    }
    function handleFocus() {
      var _a;
      (_a = dom(tabRef)) == null ? void 0 : _a.focus();
    }
    function handleSelection() {
      var _a;
      if (props.disabled)
        return;
      (_a = dom(tabRef)) == null ? void 0 : _a.focus();
      api.setSelectedIndex(myIndex.value);
    }
    let type = useResolveButtonType((0, import_vue22.computed)(() => ({ as: props.as, type: attrs.type })), tabRef);
    return () => {
      var _a, _b;
      let slot = { selected: selected.value };
      let propsWeControl = {
        ref: tabRef,
        onKeydown: handleKeyDown,
        onFocus: api.activation.value === "manual" ? handleFocus : handleSelection,
        onClick: handleSelection,
        id: id2,
        role: "tab",
        type: type.value,
        "aria-controls": (_b = (_a = api.panels.value[myIndex.value]) == null ? void 0 : _a.value) == null ? void 0 : _b.id,
        "aria-selected": selected.value,
        tabIndex: selected.value ? 0 : -1,
        disabled: props.disabled ? true : void 0
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        name: "Tab"
      });
    };
  }
});
var TabPanels = (0, import_vue22.defineComponent)({
  name: "TabPanels",
  props: {
    as: { type: [Object, String], default: "div" }
  },
  setup(props, { slots, attrs }) {
    let api = useTabsContext("TabPanels");
    return () => {
      let slot = { selectedIndex: api.selectedIndex.value };
      return render({
        props,
        slot,
        attrs,
        slots,
        name: "TabPanels"
      });
    };
  }
});
var TabPanel = (0, import_vue22.defineComponent)({
  name: "TabPanel",
  props: {
    as: { type: [Object, String], default: "div" },
    static: { type: Boolean, default: false },
    unmount: { type: Boolean, default: true }
  },
  setup(props, { attrs, slots }) {
    let api = useTabsContext("TabPanel");
    let id2 = `headlessui-tabs-panel-${useId()}`;
    let panelRef = (0, import_vue22.ref)();
    (0, import_vue22.onMounted)(() => api.registerPanel(panelRef));
    (0, import_vue22.onUnmounted)(() => api.unregisterPanel(panelRef));
    let myIndex = (0, import_vue22.computed)(() => api.panels.value.indexOf(panelRef));
    let selected = (0, import_vue22.computed)(() => myIndex.value === api.selectedIndex.value);
    return () => {
      var _a, _b;
      let slot = { selected: selected.value };
      let propsWeControl = {
        ref: panelRef,
        id: id2,
        role: "tabpanel",
        "aria-labelledby": (_b = (_a = api.tabs.value[myIndex.value]) == null ? void 0 : _a.value) == null ? void 0 : _b.id,
        tabIndex: selected.value ? 0 : -1
      };
      return render({
        props: { ...props, ...propsWeControl },
        slot,
        attrs,
        slots,
        features: 2 /* Static */ | 1 /* RenderStrategy */,
        visible: selected.value,
        name: "TabPanel"
      });
    };
  }
});

// src/components/transitions/transition.ts
var import_vue23 = require("vue");

// src/utils/once.ts
function once(cb) {
  let state = { called: false };
  return (...args) => {
    if (state.called)
      return;
    state.called = true;
    return cb(...args);
  };
}

// src/utils/disposables.ts
function disposables() {
  let disposables2 = [];
  let queue = [];
  let api = {
    enqueue(fn) {
      queue.push(fn);
    },
    requestAnimationFrame(...args) {
      let raf = requestAnimationFrame(...args);
      api.add(() => cancelAnimationFrame(raf));
    },
    nextFrame(...args) {
      api.requestAnimationFrame(() => {
        api.requestAnimationFrame(...args);
      });
    },
    setTimeout(...args) {
      let timer = setTimeout(...args);
      api.add(() => clearTimeout(timer));
    },
    add(cb) {
      disposables2.push(cb);
    },
    dispose() {
      for (let dispose of disposables2.splice(0)) {
        dispose();
      }
    },
    async workQueue() {
      for (let handle of queue.splice(0)) {
        await handle();
      }
    }
  };
  return api;
}

// src/components/transitions/utils/transition.ts
function addClasses(node, ...classes) {
  node && classes.length > 0 && node.classList.add(...classes);
}
function removeClasses(node, ...classes) {
  node && classes.length > 0 && node.classList.remove(...classes);
}
function waitForTransition(node, done) {
  let d = disposables();
  if (!node)
    return d.dispose;
  let { transitionDuration, transitionDelay } = getComputedStyle(node);
  let [durationMs, delaysMs] = [transitionDuration, transitionDelay].map((value) => {
    let [resolvedValue = 0] = value.split(",").filter(Boolean).map((v) => v.includes("ms") ? parseFloat(v) : parseFloat(v) * 1e3).sort((a, z) => z - a);
    return resolvedValue;
  });
  if (durationMs !== 0) {
    d.setTimeout(() => done("finished" /* Finished */), durationMs + delaysMs);
  } else {
    done("finished" /* Finished */);
  }
  d.add(() => done("cancelled" /* Cancelled */));
  return d.dispose;
}
function transition(node, base, from, to, entered, done) {
  let d = disposables();
  let _done = done !== void 0 ? once(done) : () => {
  };
  removeClasses(node, ...entered);
  addClasses(node, ...base, ...from);
  d.nextFrame(() => {
    removeClasses(node, ...from);
    addClasses(node, ...to);
    d.add(waitForTransition(node, (reason) => {
      removeClasses(node, ...to, ...base);
      addClasses(node, ...entered);
      return _done(reason);
    }));
  });
  d.add(() => removeClasses(node, ...base, ...from, ...to, ...entered));
  d.add(() => _done("cancelled" /* Cancelled */));
  return d.dispose;
}

// src/components/transitions/transition.ts
function splitClasses(classes = "") {
  return classes.split(" ").filter((className) => className.trim().length > 1);
}
var TransitionContext = Symbol("TransitionContext");
function hasTransitionContext() {
  return (0, import_vue23.inject)(TransitionContext, null) !== null;
}
function useTransitionContext() {
  let context = (0, import_vue23.inject)(TransitionContext, null);
  if (context === null) {
    throw new Error("A <TransitionChild /> is used but it is missing a parent <TransitionRoot />.");
  }
  return context;
}
function useParentNesting() {
  let context = (0, import_vue23.inject)(NestingContext, null);
  if (context === null) {
    throw new Error("A <TransitionChild /> is used but it is missing a parent <TransitionRoot />.");
  }
  return context;
}
var NestingContext = Symbol("NestingContext");
function hasChildren(bag) {
  if ("children" in bag)
    return hasChildren(bag.children);
  return bag.value.filter(({ state }) => state === "visible" /* Visible */).length > 0;
}
function useNesting(done) {
  let transitionableChildren = (0, import_vue23.ref)([]);
  let mounted = (0, import_vue23.ref)(false);
  (0, import_vue23.onMounted)(() => mounted.value = true);
  (0, import_vue23.onUnmounted)(() => mounted.value = false);
  function unregister(childId, strategy = 1 /* Hidden */) {
    let idx = transitionableChildren.value.findIndex(({ id: id2 }) => id2 === childId);
    if (idx === -1)
      return;
    match(strategy, {
      [0 /* Unmount */]() {
        transitionableChildren.value.splice(idx, 1);
      },
      [1 /* Hidden */]() {
        transitionableChildren.value[idx].state = "hidden" /* Hidden */;
      }
    });
    if (!hasChildren(transitionableChildren) && mounted.value) {
      done == null ? void 0 : done();
    }
  }
  function register(childId) {
    let child = transitionableChildren.value.find(({ id: id2 }) => id2 === childId);
    if (!child) {
      transitionableChildren.value.push({ id: childId, state: "visible" /* Visible */ });
    } else if (child.state !== "visible" /* Visible */) {
      child.state = "visible" /* Visible */;
    }
    return () => unregister(childId, 0 /* Unmount */);
  }
  return {
    children: transitionableChildren,
    register,
    unregister
  };
}
var TransitionChildRenderFeatures = 1 /* RenderStrategy */;
var TransitionChild = (0, import_vue23.defineComponent)({
  props: {
    as: { type: [Object, String], default: "div" },
    show: { type: [Boolean], default: null },
    unmount: { type: [Boolean], default: true },
    appear: { type: [Boolean], default: false },
    enter: { type: [String], default: "" },
    enterFrom: { type: [String], default: "" },
    enterTo: { type: [String], default: "" },
    entered: { type: [String], default: "" },
    leave: { type: [String], default: "" },
    leaveFrom: { type: [String], default: "" },
    leaveTo: { type: [String], default: "" }
  },
  emits: {
    beforeEnter: () => true,
    afterEnter: () => true,
    beforeLeave: () => true,
    afterLeave: () => true
  },
  setup(props, { emit, attrs, slots }) {
    if (!hasTransitionContext() && hasOpenClosed()) {
      return () => (0, import_vue23.h)(TransitionRoot, {
        ...props,
        onBeforeEnter: () => emit("beforeEnter"),
        onAfterEnter: () => emit("afterEnter"),
        onBeforeLeave: () => emit("beforeLeave"),
        onAfterLeave: () => emit("afterLeave")
      }, slots);
    }
    let container = (0, import_vue23.ref)(null);
    let state = (0, import_vue23.ref)("visible" /* Visible */);
    let strategy = (0, import_vue23.computed)(() => props.unmount ? 0 /* Unmount */ : 1 /* Hidden */);
    let { show, appear } = useTransitionContext();
    let { register, unregister } = useParentNesting();
    let initial = { value: true };
    let id2 = useId();
    let isTransitioning = { value: false };
    let nesting = useNesting(() => {
      if (!isTransitioning.value) {
        state.value = "hidden" /* Hidden */;
        unregister(id2);
        emit("afterLeave");
      }
    });
    (0, import_vue23.onMounted)(() => {
      let unregister2 = register(id2);
      (0, import_vue23.onUnmounted)(unregister2);
    });
    (0, import_vue23.watchEffect)(() => {
      if (strategy.value !== 1 /* Hidden */)
        return;
      if (!id2)
        return;
      if (show && state.value !== "visible" /* Visible */) {
        state.value = "visible" /* Visible */;
        return;
      }
      match(state.value, {
        ["hidden" /* Hidden */]: () => unregister(id2),
        ["visible" /* Visible */]: () => register(id2)
      });
    });
    let enterClasses = splitClasses(props.enter);
    let enterFromClasses = splitClasses(props.enterFrom);
    let enterToClasses = splitClasses(props.enterTo);
    let enteredClasses = splitClasses(props.entered);
    let leaveClasses = splitClasses(props.leave);
    let leaveFromClasses = splitClasses(props.leaveFrom);
    let leaveToClasses = splitClasses(props.leaveTo);
    (0, import_vue23.onMounted)(() => {
      (0, import_vue23.watchEffect)(() => {
        if (state.value === "visible" /* Visible */) {
          let domElement = dom(container);
          let isEmptyDOMNode = domElement instanceof Comment && domElement.data === "";
          if (isEmptyDOMNode) {
            throw new Error("Did you forget to passthrough the `ref` to the actual DOM node?");
          }
        }
      });
    });
    function executeTransition(onInvalidate) {
      let skip = initial.value && !appear.value;
      let node = dom(container);
      if (!node || !(node instanceof HTMLElement))
        return;
      if (skip)
        return;
      isTransitioning.value = true;
      if (show.value)
        emit("beforeEnter");
      if (!show.value)
        emit("beforeLeave");
      onInvalidate(show.value ? transition(node, enterClasses, enterFromClasses, enterToClasses, enteredClasses, (reason) => {
        isTransitioning.value = false;
        if (reason === "finished" /* Finished */)
          emit("afterEnter");
      }) : transition(node, leaveClasses, leaveFromClasses, leaveToClasses, enteredClasses, (reason) => {
        isTransitioning.value = false;
        if (reason !== "finished" /* Finished */)
          return;
        if (!hasChildren(nesting)) {
          state.value = "hidden" /* Hidden */;
          unregister(id2);
          emit("afterLeave");
        }
      }));
    }
    (0, import_vue23.onMounted)(() => {
      (0, import_vue23.watch)([show, appear], (_oldValues, _newValues, onInvalidate) => {
        executeTransition(onInvalidate);
        initial.value = false;
      }, { immediate: true });
    });
    (0, import_vue23.provide)(NestingContext, nesting);
    useOpenClosedProvider((0, import_vue23.computed)(() => match(state.value, {
      ["visible" /* Visible */]: 0 /* Open */,
      ["hidden" /* Hidden */]: 1 /* Closed */
    })));
    return () => {
      let {
        appear: appear2,
        show: show2,
        enter,
        enterFrom,
        enterTo,
        entered,
        leave,
        leaveFrom,
        leaveTo,
        ...rest
      } = props;
      let propsWeControl = { ref: container };
      let passthroughProps = rest;
      return render({
        props: { ...passthroughProps, ...propsWeControl },
        slot: {},
        slots,
        attrs,
        features: TransitionChildRenderFeatures,
        visible: state.value === "visible" /* Visible */,
        name: "TransitionChild"
      });
    };
  }
});
var _TransitionChild = TransitionChild;
var TransitionRoot = (0, import_vue23.defineComponent)({
  inheritAttrs: false,
  props: {
    as: { type: [Object, String], default: "div" },
    show: { type: [Boolean], default: null },
    unmount: { type: [Boolean], default: true },
    appear: { type: [Boolean], default: false },
    enter: { type: [String], default: "" },
    enterFrom: { type: [String], default: "" },
    enterTo: { type: [String], default: "" },
    entered: { type: [String], default: "" },
    leave: { type: [String], default: "" },
    leaveFrom: { type: [String], default: "" },
    leaveTo: { type: [String], default: "" }
  },
  emits: {
    beforeEnter: () => true,
    afterEnter: () => true,
    beforeLeave: () => true,
    afterLeave: () => true
  },
  setup(props, { emit, attrs, slots }) {
    let usesOpenClosedState = useOpenClosed();
    let show = (0, import_vue23.computed)(() => {
      if (props.show === null && usesOpenClosedState !== null) {
        return match(usesOpenClosedState.value, {
          [0 /* Open */]: true,
          [1 /* Closed */]: false
        });
      }
      return props.show;
    });
    (0, import_vue23.watchEffect)(() => {
      if (![true, false].includes(show.value)) {
        throw new Error('A <Transition /> is used but it is missing a `:show="true | false"` prop.');
      }
    });
    let state = (0, import_vue23.ref)(show.value ? "visible" /* Visible */ : "hidden" /* Hidden */);
    let nestingBag = useNesting(() => {
      state.value = "hidden" /* Hidden */;
    });
    let initial = { value: true };
    let transitionBag = {
      show,
      appear: (0, import_vue23.computed)(() => props.appear || !initial.value)
    };
    (0, import_vue23.onMounted)(() => {
      (0, import_vue23.watchEffect)(() => {
        initial.value = false;
        if (show.value) {
          state.value = "visible" /* Visible */;
        } else if (!hasChildren(nestingBag)) {
          state.value = "hidden" /* Hidden */;
        }
      });
    });
    (0, import_vue23.provide)(NestingContext, nestingBag);
    (0, import_vue23.provide)(TransitionContext, transitionBag);
    return () => {
      let passThroughProps = omit(props, ["show", "appear", "unmount"]);
      let sharedProps = { unmount: props.unmount };
      return render({
        props: {
          ...sharedProps,
          as: "template"
        },
        slot: {},
        slots: {
          ...slots,
          default: () => [
            (0, import_vue23.h)(_TransitionChild, {
              onBeforeEnter: () => emit("beforeEnter"),
              onAfterEnter: () => emit("afterEnter"),
              onBeforeLeave: () => emit("beforeLeave"),
              onAfterLeave: () => emit("afterLeave"),
              ...attrs,
              ...sharedProps,
              ...passThroughProps
            }, slots.default)
          ]
        },
        attrs: {},
        features: TransitionChildRenderFeatures,
        visible: state.value === "visible" /* Visible */,
        name: "Transition"
      });
    };
  }
});
module.exports = __toCommonJS(src_exports);
