# ej2-base

A common package of Essential JS 2 which contains base libraries, methods and class definitions.

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's EULA (https://www.syncfusion.com/eula/es/). To acquire a license, you can purchase one at https://www.syncfusion.com/sales/products or start a free 30-day trial here (https://www.syncfusion.com/account/manage-trials/start-trials).
>
> A free community license (https://www.syncfusion.com/products/communitylicense) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install `ej2-base`, use the following command.

```sh
npm install @syncfusion/ej2-base
```

## Resources

* [Getting Started](https://ej2.syncfusion.com/documentation/getting-started?utm_source=npm&utm_campaign=ej2-base)
* [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=ej2-base)
* [Product Page](https://www.syncfusion.com/products/javascript?utm_source=npm&utm_campaign=ej2-base)

## Framework highlights

### Lightweight and user friendly

The entire Essential JS 2 framework is built from scratch to be lightweight and modular. Its footprint can be reduced further by including only the specific components and features your application requires.

### Modular architecture

All components have been built as modules to enable selective referencing, so only the components and features you need are included in your application.

### Built for performance

Performance is critical for delivering a good user experience. We ensure that all our components are designed and built to achieve the best performance possible.

### Responsive and touch friendly

All Essential JS 2 controls are touch friendly and render adaptively based on the device they are on to provide optimal usage experience on phones, tablets and desktops.

### Stunning built-in themes

Pixel-perfect built-in themes are available in material, bootstrap and fabric design. In addition, it comes with Accessible high-contrast theme and an online tool "[Theme Studio](https://ej2.syncfusion.com/themestudio/)" to customize the provided built-in themes.

### Globalization simplified

Easily build applications to be used by a global audience in various language and culture settings.

### Stay current

With our commitment to at least four major updates per year, you receive the most up-to-date functionality and new components in addition to monthly service packs and bug fixes. Custom patches are available as needed.

## Supported Frameworks

The Essential JS 2 is also offered in following list of frameworks.

* [Angular](https://www.syncfusion.com/products/angular?utm_source=npm&utm_campaign=ej2-base)
* [React](https://www.syncfusion.com/products/react?utm_source=npm&utm_campaign=ej2-base)
* [Vue.js](https://www.syncfusion.com/products/vue?utm_source=npm&utm_campaign=ej2-base)
* [ASP.NET Core](https://www.syncfusion.com/products/aspnetcore?utm_source=npm&utm_campaign=ej2-base)
* [ASP.NET MVC](https://www.syncfusion.com/products/aspnetmvc?utm_source=npm&utm_campaign=ej2-base)

## Showcase Applications

* [Diagram Builder](https://ej2.syncfusion.com/showcase/angular/diagrambuilder?utm_source=npm&utm_campaign=ej2-base)
* [Expense Tracker](https://ej2.syncfusion.com/showcase/typescript/expensetracker?utm_source=npm&utm_campaign=ej2-base)
* [IT Asset Management](https://ej2.syncfusion.com/showcase/vue/assetmanagement?utm_source=npm&utm_campaign=ej2-base)
* [Loan Calculator](https://ej2.syncfusion.com/showcase/typescript/loancalculator?utm_source=npm&utm_campaign=ej2-base)
* [Stock Chart](https://ej2.syncfusion.com/showcase/angular/stockchart?utm_source=npm&utm_campaign=ej2-base)
* [Story Estimator](https://aspdotnetcore.syncfusion.com/showcase/aspnetcore/story-estimator/)
* [Web Mail](https://ej2.syncfusion.com/showcase/typescript/webmail?utm_source=npm&utm_campaign=ej2-base)

## Key Features

* Ajax
* Animation
* Drag and Drop
* Internationalization
* Localization
* Template Engine
* Right to Left
* State Persistence

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents?utm_source=npm&utm_campaign=ej2-base) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2?utm_source=npm&utm_campaign=ej2-base).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
* Ask your query in [Stack Overflow](https://stackoverflow.com/) with tag `syncfusion` and `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license).

## Changelog

Check the changelog [here](https://ej2.syncfusion.com/documentation/release-notes/index?utm_source=npm&utm_campaign=ej2-base)

    © Copyright 2022 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.
    The Syncfusion Essential Studio license and copyright applies to this distribution.
