# ej2-buttons

A package of Syncfusion JavaScript UI Components (Essential JS 2) Button, CheckBox, RadioButton and Switch.

![Button](https://ej2.syncfusion.com/products/images/button/readme.gif)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's EULA (https://www.syncfusion.com/eula/es/). To acquire a license, you can purchase one at https://www.syncfusion.com/sales/products or start a free 30-day trial here (https://www.syncfusion.com/account/manage-trials/start-trials).

> A free community license (https://www.syncfusion.com/products/communitylicense) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install `Button` and its dependent packages, use the following command

```sh
npm install @syncfusion/ej2-buttons
```

## Components included

Following list of components are available in the package.

* Button - `Button` is a graphical user interface element that triggers an event on its click action.
    * [Getting Started](https://ej2.syncfusion.com/documentation/button/getting-started?lang=typescript&utm_source=npm&utm_campaign=button)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=button#/material/button/default.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/button)

* CheckBox - `CheckBox` is a graphical user interface element that allows to select one or more options from the choices.
    * [Getting Started](https://ej2.syncfusion.com/documentation/check-box/getting-started?lang=typescript&utm_source=npm&utm_campaign=check-box)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=check-box#/material/button/check-box.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/checkbox)

* RadioButton - `RadioButton` is a graphical user interface element that allows to select one option from the choices.
    * [Getting Started](https://ej2.syncfusion.com/documentation/radio-button/getting-started?lang=typescript&utm_source=npm&utm_campaign=radio-button)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=radio-button#/material/button/radio-button.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/radio-button)

* Switch - `Switch` is a graphical user interface element that allows you to toggle between checked and unchecked states.
    * [Getting Started](https://ej2.syncfusion.com/documentation/switch/getting-started?lang=typescript&utm_source=npm&utm_campaign=switch)
    * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=switch#/material/button/switch.html)
    * [Product Page](https://www.syncfusion.com/javascript-ui-controls/toggle-switch-button)

## Supported Frameworks

These components are available in following list of frameworks.

1. [Angular](https://github.com/syncfusion/ej2-angular-ui-components/tree/master/components/buttons?utm_source=npm&utm_campaign=button)
2. [React](https://github.com/syncfusion/ej2-react-ui-components/tree/master/components/buttons?utm_source=npm&utm_campaign=button)
3. [VueJS](https://github.com/syncfusion/ej2-vue-ui-components/tree/master/components/buttons?utm_source=npm&utm_campaign=button)
4. [ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls)
5. [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls)
6. [JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls)

## Showcase samples

* Expense Tracker ([Source](https://github.com/syncfusion/ej2-sample-ts-expensetracker), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/expensetracker/?utm_source=npm&utm_campaign=button#/dashboard))
* Loan Calculator ([Source](https://github.com/syncfusion/ej2-sample-ts-loancalculator), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/loancalculator/?utm_source=npm&utm_campaign=button))

## Key Features

### Button

* [**Types**](https://ej2.syncfusion.com/documentation/button/types-and-styles#button-types) - Provided with different types of Button.

* [**Predefined Styles**](https://ej2.syncfusion.com/documentation/button/types-and-styles#button-styles) - Provided with predefined styles of Button.

* [**Sizes**](https://ej2.syncfusion.com/documentation/button/types-and-styles#button-size) - Provided with different sizes of Button.

* [**Icons**](https://ej2.syncfusion.com/documentation/button/types-and-styles#icons) - Supports text and icon on the Button.

### CheckBox

* [**States**](https://ej2.syncfusion.com/documentation/check-box/getting-started#change-the-checkbox-state) - Provided with different states of CheckBox.

* [**Label**](https://ej2.syncfusion.com/documentation/check-box/label-and-size#label) - Supports label and its positioning.

* [**Sizes**](https://ej2.syncfusion.com/documentation/check-box/label-and-size#size) - Provided with different sizes of CheckBox.

### RadioButton

* [**States**](https://ej2.syncfusion.com/documentation/radio-button/getting-started#change-the-radiobutton-state) - Provided with different states of RadioButton.

* [**Label**](https://ej2.syncfusion.com/documentation/radio-button/label-and-size#label) - Supports label and its positioning.

* [**Sizes**](https://ej2.syncfusion.com/documentation/radio-button/label-and-size#size) - Provided with different sizes of RadioButton.

### Switch

* [**Text**](https://ej2.syncfusion.com/documentation/switch/getting-started#set-text-on-switch) - Supports text.
* [**Sizes**](https://ej2.syncfusion.com/documentation/switch/how-to#change-size) - Provided with different sizes of Switch.

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents?utm_source=npm&utm_campaign=button) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2?utm_source=npm&utm_campaign=button).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
* Ask your query in [Stack Overflow](https://stackoverflow.com/?utm_source=npm&utm_campaign=button) with tag `syncfusion`, `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license?utm_source=npm&utm_campaign=button).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/buttons/CHANGELOG.md?utm_source=npm&utm_campaign=button)

© Copyright 2022 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.
