# ej2-navigations

![ej2-navigations](https://ej2.syncfusion.com/products/images/navigations/readMe.gif)

> This is a commercial product and requires a paid license for possession or use. Syncfusion’s licensed software, including this component, is subject to the terms and conditions of Syncfusion's [EULA](https://www.syncfusion.com/eula/es/). To acquire a license, you can purchase one at [https://www.syncfusion.com/sales/products](https://www.syncfusion.com/sales/products) or start a free 30-day trial [here](https://www.syncfusion.com/account/manage-trials/start-trials).

> A free [community license](https://www.syncfusion.com/products/communitylicense) is also available for companies and individuals whose organizations have less than $1 million USD in annual gross revenue and five or fewer developers.

## Setup

To install `Navigations` and its dependent packages, use the following command.

```sh
npm install @syncfusion/ej2-navigations
```

## Components included

Following list of components are available in the package

* Accordion - Vertically collapsible content panel that displays one or more panels at a time within the available space.

  * [Getting Started](https://ej2.syncfusion.com/documentation/accordion/getting-started.html?lang=typescript&utm_source=npm&utm_campaign=accordion)
  * [API References](https://ej2.syncfusion.com/documentation/accordion/api-accordion.html?utm_source=npm&utm_campaign=accordion)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=accordion#/material/accordion/default.html)
  * [Product Page](https://www.syncfusion.com/products/javascript/accordion)

* Breadcrumb - Graphical user interface that helps to identify or highlight the current location within a hierarchical structure of websites. The aim is to make the user aware of their current position in a hierarchy of website links.

  * [Getting Started](https://ej2.syncfusion.com/documentation/breadcrumb/getting-started?lang=typescript&utm_source=npm&utm_campaign=breadcrumb)
  * [API References](https://ej2.syncfusion.com/documentation/api/breadcrumb?utm_source=npm&utm_campaign=breadcrumb)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=breadcrumb#/material/breadcrumb/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/js-breadcrumb)

* ContextMenu - Graphical user interface that appears on the user right click/touch hold action. It has the support to provide nested level menu items.

  * [Getting Started](https://ej2.syncfusion.com/documentation/context-menu/getting-started?lang=typescript&utm_source=npm&utm_campaign=context-menu)
  * [API References](https://ej2.syncfusion.com/documentation/api/context-menu?utm_source=npm&utm_campaign=context-menu)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=context-menu#/material/context-menu/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/context-menu)

* Sidebar - Expandable and collapsible component that typically acts as a side container to place primary or secondary content alongside the main content.

  * [Getting started](https://ej2.syncfusion.com/documentation/sidebar/getting-started?lang=typescript&utm_source=npm&utm_campaign=sidebar#getting-started)
  * [API references](https://ej2.syncfusion.com/documentation/api/sidebar?utm_source=npm&utm_campaign=sidebar)
  * [View online demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tab#/material/sidebar/default.html)
  * [Product page](https://www.syncfusion.com/products/javascript-ui-controls/sidebar)

* Tab - Content panel to show multiple contents in a specific space, one at a time.

  * [Getting Started](https://ej2.syncfusion.com/documentation/tab/getting-started.html?lang=typescript&utm_source=npm&utm_campaign=tab)
  * [API References](https://ej2.syncfusion.com/documentation/tab/api-tab.html?utm_source=npm&utm_campaign=tab)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=tab#/material/tab/default.html)
  * [Product Page](https://www.syncfusion.com/products/javascript/tab)

* Toolbar - Displays a group of command buttons arranged horizontally.

  * [Getting Started](https://ej2.syncfusion.com/documentation/toolbar/getting-started.html?lang=typescript&utm_source=npm&utm_campaign=toolbar)
  * [API References](https://ej2.syncfusion.com/documentation/toolbar/api-toolbar.html?utm_source=npm&utm_campaign=toolbar)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=toolbar#/material/toolbar/default.html)
  * [Product Page](https://www.syncfusion.com/products/javascript/toolbar)

* TreeView - Represent hierarchical data in a tree like structure with advanced functions to edit, drag and drop, select with CheckBox and more.

  * [Getting Started](https://ej2.syncfusion.com/documentation/treeview/getting-started.html?lang=typescript&utm_source=npm&utm_campaign=treeview)
  * [API References](https://ej2.syncfusion.com/documentation/api/treeview?lang=typescript&utm_source=npm&utm_campaign=treeview)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=treeview#/material/treeview/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/treeview)

* Menu - Graphical user interface that serves as navigation header for your application or site. It has the support to provide nested level menu items that can be populated from a data source such as an array of JavaScript objects.

  * [Getting Started](https://ej2.syncfusion.com/documentation/menu/getting-started?lang=typescript&utm_source=npm&utm_campaign=menu)
  * [API References](https://ej2.syncfusion.com/documentation/api/menu?utm_source=npm&utm_campaign=menu)
  * [View Online Demos](https://ej2.syncfusion.com/demos/?utm_source=npm&utm_campaign=menu#/material/menu/default.html)
  * [Product Page](https://www.syncfusion.com/javascript-ui-controls/menu)

## Supported Frameworks

`Navigation` component is also offered in following list of frameworks,

1. [Angular](https://github.com/syncfusion/ej2-angular-ui-components/tree/master/components/navigations?utm_source=npm&utm_campaign=navigation)
2. [React](https://github.com/syncfusion/ej2-react-ui-components/tree/master/components/navigations?utm_source=npm&utm_campaign=navigation)
3. [VueJS](https://github.com/syncfusion/ej2-vue-ui-components/tree/master/components/navigations?utm_source=npm&utm_campaign=navigation)
4. [ASP.NET Core](https://www.syncfusion.com/aspnet-core-ui-controls/accordion)
5. [ASP.NET MVC](https://www.syncfusion.com/aspnet-mvc-ui-controls/accordion)
6. [JavaScript (ES5)](https://www.syncfusion.com/javascript-ui-controls/accordion)

## Use-case samples / Showcase samples

Sidebar component is used in the following samples.

* Expanse tracker ([Source](https://github.com/syncfusion/ej2-sample-ts-expensetracker), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/expensetracker/?utm_source=npm&utm_campaign=sidebar#/dashboard))
* Web mail ([Source](https://github.com/syncfusion/ej2-sample-ts-webmail), [Live Demo](https://ej2.syncfusion.com/showcase/typescript/webmail/?utm_source=npm&utm_campaign=sidebar))

## Key Features

### Accordion

1. **Rendering** - Can be rendered based on the items collection and HTML elements.
2. **Expand Mode** - Supports to define single or multiple expand mode for Accordion panels.
3. **RTL Support** - Supports right-to-left alignment.
4. **Accessibility** - Provides built-in compliance with the WAI-ARIA specifications and it is achieved through attributes. By default, it allows to interact with Accordion by using keyboard shortcuts.

### Breadcrumb

1. **Icons** - Icons can be specified in Breadcrumb items.
2. **Template** - Supports template for item and separator.
3. **Bind To Location** - Supports items to be rendered based on the URL or current location.
4. **Overflow Mode** - Used to limit the number of breadcrumb items to be displayed.
5. **Accessibility** - Provided with built-in accessibility support that helps to access all the Breadcrumb component features through the keyboard, screen readers, or other assistive technology devices.

### ContextMenu

1. **Separator** - Supports menu items grouping by using the Separator.
2. **Icons and Navigations** - Supports items to have Icons and Navigation URL's.
3. **Template and Multilevel Nesting** - Supports template and multilevel nesting in ContextMenu.
4. **Accessibility** - Provided with built-in accessibility support that helps to access all the ContextMenu component features through the keyboard, screen readers, or other assistive technology devices.

### Toolbar

1. **Scrollable** - Scrollable display mode displays Toolbar commands in a single line with horizontal scrolling enabled when the commands overflow available space.
2. **Popup** - Popup display mode displays commands in the popup when the commands overflow available space.
3. **Template Support** - The Toolbar component can also be rendered based on the given HTML element aside from item based collection rendering.
4. **Keyboard Support** - By default, the Toolbar allows interaction with commands by using keyboard shortcuts.
5. **RTL Support** - The Toolbar supports right-to-left alignment.
6. **Accessibility** - The Toolbar provides built-in compliance with the WAI-ARIA specifications and it is achieved through attributes.

### Tab

1. **Rendering** - Can be rendered based on the items collection and HTML elements.
2. **Adaptive** - Supports responsive rendering with scrollable Tabs and popup menu.
3. **Customization** - Provides customization support for header with icons and orientation.
4. **Animation** - Supports animation effects for moving previous/next contents of Tab.
5. **Accessibility** - Provides built-in compliance with the WAI-ARIA specifications and it is achieved through attributes. By default, it allows to interact with Tab headers by using keyboard shortcuts.

### Sidebar

1. **Target** - The sidebar can be initialized in any HTML element other than the body element.
2. **Types** - Provides complete control over the appearance of the sidebar component. The different types of the sidebar control give flexibility to view or hide the content (primary/secondary) over/above the main content by pushing, sliding, or overlaying it.
3. **Left or right positions** - The sidebar control can be positioned to the left or right side of the main content area. This option allows placement of two sidebars in a page, at the left and right, to show primary content and secondary content, simultaneously.
4. **Docking** - Docking lets the sidebar occupy a small vertical area in a page always and typically contains shortened view of navigation options.
5. **Auto close** - Auto closing the sidebar control’s content allows the main content area to be more readable based on screen resolution.

### TreeView

1. **Data Binding** - Binds the TreeView component with an array of JavaScript objects or DataManager.
2. **CheckBox** - Allows you to select more than one node in TreeView without affecting the UI appearance.
3. **Drag and Drop** - Allows you to drag and drop any node in TreeView.
4. **Multi Selection** - Allows you to select more than one node in TreeView.
5. **Node Editing** - Allows you to change the text of a node in TreeView.
6. **Sorting** - Allows display of the TreeView nodes in an ascending or a descending order.
7. **Template** - Allows you to customize the nodes in TreeView.
8. **Accessibility** - Provides built-in accessibility support that helps to access all the TreeView component features through the keyboard, on-screen readers, or other assistive technology devices.

### Menu

1. **Rendering** - Supports to render based on the items collection (array of JavaScript objects) and HTML elements.
2. **Separator** - Supports menu items grouping by using the Separator.
3. **Icons and Navigations** - Supports items to have Icons and Navigation URL's.
4. **Template and Multilevel Nesting** - Supports template and multilevel nesting in Menu.
5. **Accessibility** - Provided with built-in accessibility support that helps to access all the Menu component features through the keyboard, screen readers, or other assistive technology devices.

## Support

Product support is available for through following mediums.

* Creating incident in Syncfusion [Direct-trac](https://www.syncfusion.com/support/directtrac/incidents?utm_source=npm&utm_campaign=navigation) support system or [Community forum](https://www.syncfusion.com/forums/essential-js2?utm_source=npm&utm_campaign=navigation).
* New [GitHub issue](https://github.com/syncfusion/ej2-javascript-ui-controls/issues/new).
* Ask your query in [Stack Overflow](https://stackoverflow.com/?utm_source=npm&utm_campaign=navigation) with tag `syncfusion` and `ej2`.

## License

Check the license detail [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/license?utm_source=npm&utm_campaign=navigation).

## Changelog

Check the changelog [here](https://github.com/syncfusion/ej2-javascript-ui-controls/blob/master/controls/navigations/CHANGELOG.md?utm_source=npm&utm_campaign=navigation)

© Copyright 2022 Syncfusion, Inc. All Rights Reserved. The Syncfusion Essential Studio license and copyright applies to this distribution.