import * as Vue from 'vue';
import { setTemplateEngine, getTemplateEngine, getUniqueID, createElement, detach, extend, getValue, } from "@syncfusion/ej2-base";
import { allVue, gh } from "./component-base";
// tslint:disable:no-any
var stringCompiler = getTemplateEngine();
export function compile(templateElement, helper) {
    var that = this;
    if (typeof templateElement === "string") {
        return stringCompiler(templateElement, helper);
    }
    else {
        return function (data, context, propName) {
            var pid = getUniqueID("templateParentDiv");
            var id = getUniqueID("templateDiv");
            var ele = createElement("div", {
                id: pid,
                innerHTML: '<div id="' + id + '"></div>',
            });
            document.body.appendChild(ele);
            var tempObj = templateElement.call(that, {});
            var returnEle;
            if (context) {
                if (gh) {
                    var object = tempObj;
                    var propsData = getValue("template.propsData", tempObj);
                    var dataObj = {
                        data: { data: extend(tempObj.data || {}, data) },
                        parent: context.vueInstance,
                    };
                    if (!object.template) {
                        object.template = object[Object.keys(object)[0]];
                    }
                    var templateCompRef = void 0;
                    if (object.template.extends) {
                        templateCompRef = object.template.extends._context.components.template;
                    }
                    else {
                        templateCompRef = object.template._context.components[templateElement.name];
                        if (!templateCompRef) {
                            var key = Object.keys(object.template._context.components)[0];
                            templateCompRef = object.template._context.components[key];
                        }
                    }
                    var tempRef_1;
                    if (propsData) {
                        tempRef_1 = Object.assign(templateCompRef.data(), propsData);
                    }
                    else {
                        tempRef_1 = Object.assign(templateCompRef.data(), dataObj.data);
                        if (templateCompRef.components) {
                            var objkeys = Object.keys(templateCompRef.components) || [];
                            var _loop_1 = function (objstring) {
                                var intComponent = templateCompRef.components[objstring];
                                if (intComponent && intComponent.data) {
                                    var tempRef2_1 = Object.assign(intComponent.data(), dataObj.data);
                                    intComponent.data = function () { return tempRef2_1; };
                                }
                            };
                            for (var _i = 0, objkeys_1 = objkeys; _i < objkeys_1.length; _i++) {
                                var objstring = objkeys_1[_i];
                                _loop_1(objstring);
                            }
                        }
                    }
                    templateCompRef.data = function () { return tempRef_1; };
                    allVue
                        .createApp(templateCompRef)
                        .mount("#" + id);
                    returnEle = ele.childNodes;
                    detach(ele);
                }
                else {
                    var templateFunction = tempObj.template;
                    var propsData = getValue("template.propsData", tempObj);
                    var dataObj = {
                        data: { data: extend(tempObj.data || {}, data) },
                        parent: context.vueInstance,
                    };
                    if (propsData) {
                        templateFunction = tempObj.template.extends;
                        dataObj.propsData = propsData;
                    }
                    if (typeof templateFunction !== "function") {
                        templateFunction = Vue.extend(templateFunction);
                    }
                    var templateVue = new templateFunction(dataObj);
                    // let templateVue = new Vue(tempObj.template);
                    // templateVue.$data.data = extend(tempObj.data, data);
                    templateVue.$mount("#" + id);
                    returnEle = ele.childNodes;
                    if (context.vueInstance) {
                        var templateInstance = context.vueInstance.templateCollection;
                        if (!templateInstance) {
                            context.vueInstance.templateCollection = {};
                            templateInstance = context.vueInstance.templateCollection;
                        }
                        if (propName) {
                            if (!templateInstance[propName]) {
                                templateInstance[propName] = [];
                            }
                            templateInstance[propName].push(returnEle[0]);
                        }
                    }
                    detach(ele);
                }
            }
            return returnEle || [];
        };
    }
}
setTemplateEngine({ compile: compile });
