import { AutoComplete, ComboBox, DropDownList, DropDownTree, ListBox, MultiSelect } from '@syncfusion/ej2-dropdowns';
import { getValue, isNullOrUndefined, isUndefined } from '@syncfusion/ej2-base';
import { ComponentBase, EJComponentDecorator, getProps, gh } from '@syncfusion/ej2-vue-base';

var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties = ['isLazyUpdate', 'actionFailureTemplate', 'allowFiltering', 'cssClass', 'dataSource', 'enablePersistence', 'enableRtl', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'floatLabelType', 'footerTemplate', 'groupTemplate', 'headerTemplate', 'htmlAttributes', 'ignoreAccent', 'ignoreCase', 'index', 'itemTemplate', 'locale', 'noRecordsTemplate', 'placeholder', 'popupHeight', 'popupWidth', 'query', 'readonly', 'showClearButton', 'sortOrder', 'text', 'value', 'valueTemplate', 'width', 'zIndex', 'actionBegin', 'actionComplete', 'actionFailure', 'beforeOpen', 'blur', 'change', 'close', 'created', 'dataBound', 'destroyed', 'filtering', 'focus', 'open', 'select'];
const modelProps = ['value'];
const testProp = getProps({ props: properties });
const props = testProp[0];
const watch = testProp[1];
const emitProbs = Object.keys(watch);
emitProbs.push('modelchanged');
for (let props of modelProps) {
    emitProbs.push('update:' + props);
}
const isExecute = gh ? false : true;
/**
 * DropDownList contains a list of predefined values from which the user can choose
 * ```html
 * <ejs-dropdownlist :dataSource='data'></ejs-dropdownlist>
 * ```
 */
let DropDownListComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class DropDownListComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties;
        this.models = modelProps;
        this.hasChildDirective = false;
        this.hasInjectedModules = false;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute;
        this.ej2Instances = new DropDownList({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    addItem(items, itemIndex) {
        return this.ej2Instances.addItem(items, itemIndex);
    }
    clear() {
        return this.ej2Instances.clear();
    }
    filter(dataSource, query, fields) {
        return this.ej2Instances.filter(dataSource, query, fields);
    }
    focusIn(e) {
        return this.ej2Instances.focusIn(e);
    }
    focusOut(e) {
        return this.ej2Instances.focusOut(e);
    }
    getDataByValue(value) {
        return this.ej2Instances.getDataByValue(value);
    }
    getItems() {
        return this.ej2Instances.getItems();
    }
    hidePopup(e) {
        return this.ej2Instances.hidePopup(e);
    }
    hideSpinner() {
        return this.ej2Instances.hideSpinner();
    }
    showPopup() {
        return this.ej2Instances.showPopup();
    }
    showSpinner() {
        return this.ej2Instances.showSpinner();
    }
};
DropDownListComponent = __decorate([
    EJComponentDecorator({
        props: properties,
        model: {
            event: 'modelchanged'
        }
    }, isExecute)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], DropDownListComponent);
const DropDownListPlugin = {
    name: 'ejs-dropdownlist',
    install(Vue) {
        Vue.component(DropDownListPlugin.name, DropDownListComponent);
    }
};

var __decorate$1 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties$1 = ['isLazyUpdate', 'actionFailureTemplate', 'allowCustom', 'allowFiltering', 'autofill', 'cssClass', 'dataSource', 'enablePersistence', 'enableRtl', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'floatLabelType', 'footerTemplate', 'groupTemplate', 'headerTemplate', 'htmlAttributes', 'ignoreAccent', 'ignoreCase', 'index', 'itemTemplate', 'locale', 'noRecordsTemplate', 'placeholder', 'popupHeight', 'popupWidth', 'query', 'readonly', 'showClearButton', 'sortOrder', 'text', 'value', 'valueTemplate', 'width', 'zIndex', 'actionBegin', 'actionComplete', 'actionFailure', 'beforeOpen', 'blur', 'change', 'close', 'created', 'customValueSpecifier', 'dataBound', 'destroyed', 'filtering', 'focus', 'open', 'select'];
const modelProps$1 = ['value'];
const testProp$1 = getProps({ props: properties$1 });
const props$1 = testProp$1[0];
const watch$1 = testProp$1[1];
const emitProbs$1 = Object.keys(watch$1);
emitProbs$1.push('modelchanged');
for (let props of modelProps$1) {
    emitProbs$1.push('update:' + props);
}
const isExecute$1 = gh ? false : true;
/**
 * ComboBox component allows the user to type a value or choose an option from the list of predefined options available
 * ```html
 * <ejs-combobox :dataSource='data'></ejs-combobox>
 * ```
 */
let ComboBoxComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class ComboBoxComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties$1;
        this.models = modelProps$1;
        this.hasChildDirective = false;
        this.hasInjectedModules = false;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute$1;
        this.ej2Instances = new ComboBox({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute$1) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$1) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$1) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    addItem(items, itemIndex) {
        return this.ej2Instances.addItem(items, itemIndex);
    }
    clear() {
        return this.ej2Instances.clear();
    }
    filter(dataSource, query, fields) {
        return this.ej2Instances.filter(dataSource, query, fields);
    }
    focusIn() {
        return this.ej2Instances.focusIn();
    }
    focusOut(e) {
        return this.ej2Instances.focusOut(e);
    }
    getDataByValue(value) {
        return this.ej2Instances.getDataByValue(value);
    }
    getItems() {
        return this.ej2Instances.getItems();
    }
    hidePopup(e) {
        return this.ej2Instances.hidePopup(e);
    }
    hideSpinner() {
        return this.ej2Instances.hideSpinner();
    }
    showPopup() {
        return this.ej2Instances.showPopup();
    }
    showSpinner() {
        return this.ej2Instances.showSpinner();
    }
};
ComboBoxComponent = __decorate$1([
    EJComponentDecorator({
        props: properties$1,
        model: {
            event: 'modelchanged'
        }
    }, isExecute$1)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], ComboBoxComponent);
const ComboBoxPlugin = {
    name: 'ejs-combobox',
    install(Vue) {
        Vue.component(ComboBoxPlugin.name, ComboBoxComponent);
    }
};

var __decorate$2 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties$2 = ['isLazyUpdate', 'actionFailureTemplate', 'allowCustom', 'allowFiltering', 'autofill', 'cssClass', 'dataSource', 'enablePersistence', 'enableRtl', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'floatLabelType', 'footerTemplate', 'groupTemplate', 'headerTemplate', 'highlight', 'htmlAttributes', 'ignoreAccent', 'ignoreCase', 'index', 'itemTemplate', 'locale', 'minLength', 'noRecordsTemplate', 'placeholder', 'popupHeight', 'popupWidth', 'query', 'readonly', 'showClearButton', 'showPopupButton', 'sortOrder', 'suggestionCount', 'text', 'value', 'valueTemplate', 'width', 'zIndex', 'actionBegin', 'actionComplete', 'actionFailure', 'beforeOpen', 'blur', 'change', 'close', 'created', 'customValueSpecifier', 'dataBound', 'destroyed', 'filtering', 'focus', 'open', 'select'];
const modelProps$2 = ['value'];
const testProp$2 = getProps({ props: properties$2 });
const props$2 = testProp$2[0];
const watch$2 = testProp$2[1];
const emitProbs$2 = Object.keys(watch$2);
emitProbs$2.push('modelchanged');
for (let props of modelProps$2) {
    emitProbs$2.push('update:' + props);
}
const isExecute$2 = gh ? false : true;
/**
 * The AutoComplete component provides all the matched suggestion list on typing the input from which the user can select one.
 * ```html
 * <ejs-autocomplete :dataSource='data'></ejs-autocomplete>
 * ```
 */
let AutoCompleteComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class AutoCompleteComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties$2;
        this.models = modelProps$2;
        this.hasChildDirective = false;
        this.hasInjectedModules = false;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute$2;
        this.ej2Instances = new AutoComplete({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute$2) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$2) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$2) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    addItem(items, itemIndex) {
        return this.ej2Instances.addItem(items, itemIndex);
    }
    clear() {
        return this.ej2Instances.clear();
    }
    filter(dataSource, query, fields) {
        return this.ej2Instances.filter(dataSource, query, fields);
    }
    focusIn() {
        return this.ej2Instances.focusIn();
    }
    focusOut(e) {
        return this.ej2Instances.focusOut(e);
    }
    getDataByValue(value) {
        return this.ej2Instances.getDataByValue(value);
    }
    getItems() {
        return this.ej2Instances.getItems();
    }
    hidePopup() {
        return this.ej2Instances.hidePopup();
    }
    hideSpinner() {
        return this.ej2Instances.hideSpinner();
    }
    showPopup() {
        return this.ej2Instances.showPopup();
    }
    showSpinner() {
        return this.ej2Instances.showSpinner();
    }
};
AutoCompleteComponent = __decorate$2([
    EJComponentDecorator({
        props: properties$2,
        model: {
            event: 'modelchanged'
        }
    }, isExecute$2)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], AutoCompleteComponent);
const AutoCompletePlugin = {
    name: 'ejs-autocomplete',
    install(Vue) {
        Vue.component(AutoCompletePlugin.name, AutoCompleteComponent);
    }
};

var __decorate$3 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties$3 = ['isLazyUpdate', 'actionFailureTemplate', 'addTagOnBlur', 'allowCustomValue', 'allowFiltering', 'changeOnBlur', 'closePopupOnSelect', 'cssClass', 'dataSource', 'delimiterChar', 'enableGroupCheckBox', 'enableHtmlSanitizer', 'enablePersistence', 'enableRtl', 'enableSelectionOrder', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'floatLabelType', 'footerTemplate', 'groupTemplate', 'headerTemplate', 'hideSelectedItem', 'htmlAttributes', 'ignoreAccent', 'ignoreCase', 'itemTemplate', 'locale', 'maximumSelectionLength', 'mode', 'noRecordsTemplate', 'openOnClick', 'placeholder', 'popupHeight', 'popupWidth', 'query', 'readonly', 'selectAllText', 'showClearButton', 'showDropDownIcon', 'showSelectAll', 'sortOrder', 'text', 'unSelectAllText', 'value', 'valueTemplate', 'width', 'zIndex', 'actionBegin', 'actionComplete', 'actionFailure', 'beforeOpen', 'beforeSelectAll', 'blur', 'change', 'chipSelection', 'close', 'created', 'customValueSelection', 'dataBound', 'destroyed', 'filtering', 'focus', 'open', 'removed', 'removing', 'select', 'selectedAll', 'tagging'];
const modelProps$3 = ['value'];
const testProp$3 = getProps({ props: properties$3 });
const props$3 = testProp$3[0];
const watch$3 = testProp$3[1];
const emitProbs$3 = Object.keys(watch$3);
emitProbs$3.push('modelchanged');
for (let props of modelProps$3) {
    emitProbs$3.push('update:' + props);
}
const isExecute$3 = gh ? false : true;
/**
 * MultiSelect component allows the user to select a value from the predefined list of values.
 * ```html
 * <ejs-multiselect :dataSource='data'></ejs-multiselect>
 * ```
 */
let MultiSelectComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class MultiSelectComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties$3;
        this.models = modelProps$3;
        this.hasChildDirective = false;
        this.hasInjectedModules = true;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute$3;
        this.ej2Instances = new MultiSelect({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute$3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$3) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$3) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    addItem(items, itemIndex) {
        return this.ej2Instances.addItem(items, itemIndex);
    }
    clear() {
        return this.ej2Instances.clear();
    }
    filter(dataSource, query, fields) {
        return this.ej2Instances.filter(dataSource, query, fields);
    }
    focusIn() {
        return this.ej2Instances.focusIn();
    }
    focusOut() {
        return this.ej2Instances.focusOut();
    }
    getDataByValue(value) {
        return this.ej2Instances.getDataByValue(value);
    }
    getItems() {
        return this.ej2Instances.getItems();
    }
    hidePopup() {
        return this.ej2Instances.hidePopup();
    }
    hideSpinner() {
        return this.ej2Instances.hideSpinner();
    }
    requiredModules() {
        return this.ej2Instances.requiredModules();
    }
    selectAll(state) {
        return this.ej2Instances.selectAll(state);
    }
    showPopup() {
        return this.ej2Instances.showPopup();
    }
    showSpinner() {
        return this.ej2Instances.showSpinner();
    }
};
MultiSelectComponent = __decorate$3([
    EJComponentDecorator({
        props: properties$3,
        model: {
            event: 'modelchanged'
        }
    }, isExecute$3)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], MultiSelectComponent);
const MultiSelectPlugin = {
    name: 'ejs-multiselect',
    install(Vue) {
        Vue.component(MultiSelectPlugin.name, MultiSelectComponent);
    }
};

var __decorate$4 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties$4 = ['isLazyUpdate', 'actionFailureTemplate', 'allowDragAndDrop', 'allowFiltering', 'cssClass', 'dataSource', 'enablePersistence', 'enableRtl', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'groupTemplate', 'height', 'ignoreAccent', 'ignoreCase', 'itemTemplate', 'locale', 'maximumSelectionLength', 'noRecordsTemplate', 'query', 'scope', 'selectionSettings', 'sortOrder', 'toolbarSettings', 'value', 'zIndex', 'actionBegin', 'actionComplete', 'actionFailure', 'beforeDrop', 'beforeItemRender', 'change', 'created', 'dataBound', 'destroyed', 'drag', 'dragStart', 'drop', 'filtering', 'select'];
const modelProps$4 = ['value'];
const testProp$4 = getProps({ props: properties$4 });
const props$4 = testProp$4[0];
const watch$4 = testProp$4[1];
const emitProbs$4 = Object.keys(watch$4);
emitProbs$4.push('modelchanged');
for (let props of modelProps$4) {
    emitProbs$4.push('update:' + props);
}
const isExecute$4 = gh ? false : true;
/**
 * ListBox component allows the user to select values from the predefined list of values.
 * ```html
 * <ejs-listbox :dataSource='data'></ejs-listbox>
 * ```
 */
let ListBoxComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class ListBoxComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties$4;
        this.models = modelProps$4;
        this.hasChildDirective = false;
        this.hasInjectedModules = true;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute$4;
        this.ej2Instances = new ListBox({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute$4) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$4) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$4) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    addItems(items, itemIndex) {
        return this.ej2Instances.addItems(items, itemIndex);
    }
    enableItems(items, enable, isValue) {
        return this.ej2Instances.enableItems(items, enable, isValue);
    }
    filter(dataSource, query, fields) {
        return this.ej2Instances.filter(dataSource, query, fields);
    }
    getDataByValue(value) {
        return this.ej2Instances.getDataByValue(value);
    }
    getDataByValues(value) {
        return this.ej2Instances.getDataByValues(value);
    }
    getDataList() {
        return this.ej2Instances.getDataList();
    }
    getItems() {
        return this.ej2Instances.getItems();
    }
    getSortedList() {
        return this.ej2Instances.getSortedList();
    }
    hideSpinner() {
        return this.ej2Instances.hideSpinner();
    }
    moveAllTo(targetId, index) {
        return this.ej2Instances.moveAllTo(targetId, index);
    }
    moveDown(value) {
        return this.ej2Instances.moveDown(value);
    }
    moveTo(value, index, targetId) {
        return this.ej2Instances.moveTo(value, index, targetId);
    }
    moveUp(value) {
        return this.ej2Instances.moveUp(value);
    }
    removeItem(items, itemIndex) {
        return this.ej2Instances.removeItem(items, itemIndex);
    }
    removeItems(items, itemIndex) {
        return this.ej2Instances.removeItems(items, itemIndex);
    }
    requiredModules() {
        return this.ej2Instances.requiredModules();
    }
    selectAll(state) {
        return this.ej2Instances.selectAll(state);
    }
    selectItems(items, state, isValue) {
        return this.ej2Instances.selectItems(items, state, isValue);
    }
    showSpinner() {
        return this.ej2Instances.showSpinner();
    }
};
ListBoxComponent = __decorate$4([
    EJComponentDecorator({
        props: properties$4,
        model: {
            event: 'modelchanged'
        }
    }, isExecute$4)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], ListBoxComponent);
const ListBoxPlugin = {
    name: 'ejs-listbox',
    install(Vue) {
        Vue.component(ListBoxPlugin.name, ListBoxComponent);
    }
};

var __decorate$5 = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
// {{VueImport}}
const properties$5 = ['isLazyUpdate', 'actionFailureTemplate', 'allowFiltering', 'allowMultiSelection', 'changeOnBlur', 'cssClass', 'customTemplate', 'delimiterChar', 'enablePersistence', 'enableRtl', 'enabled', 'fields', 'filterBarPlaceholder', 'filterType', 'floatLabelType', 'footerTemplate', 'headerTemplate', 'htmlAttributes', 'ignoreAccent', 'ignoreCase', 'itemTemplate', 'locale', 'mode', 'noRecordsTemplate', 'placeholder', 'popupHeight', 'popupWidth', 'readonly', 'selectAllText', 'showCheckBox', 'showClearButton', 'showDropDownIcon', 'showSelectAll', 'sortOrder', 'text', 'treeSettings', 'unSelectAllText', 'value', 'width', 'wrapText', 'zIndex', 'actionFailure', 'beforeOpen', 'blur', 'change', 'close', 'created', 'dataBound', 'destroyed', 'filtering', 'focus', 'keyPress', 'open', 'select'];
const modelProps$5 = ['value'];
const testProp$5 = getProps({ props: properties$5 });
const props$5 = testProp$5[0];
const watch$5 = testProp$5[1];
const emitProbs$5 = Object.keys(watch$5);
emitProbs$5.push('modelchanged');
for (let props of modelProps$5) {
    emitProbs$5.push('update:' + props);
}
const isExecute$5 = gh ? false : true;
/**
 * The DropDownTree component contains a list of predefined values from which you can choose a single or multiple values.
 * ```html
 * <ejs-dropdowntree></ejs-dropdowntree>
 * ```
 */
let DropDownTreeComponent = 
/* Start Options({
    props: props,
    watch: watch,
    emits: emitProbs
}) End */
class DropDownTreeComponent extends ComponentBase {
    constructor() {
        super(arguments);
        this.propKeys = properties$5;
        this.models = modelProps$5;
        this.hasChildDirective = false;
        this.hasInjectedModules = false;
        this.tagMapper = {};
        this.tagNameMapper = {};
        this.isVue3 = !isExecute$5;
        this.ej2Instances = new DropDownTree({});
        this.ej2Instances._trigger = this.ej2Instances.trigger;
        this.ej2Instances.trigger = this.trigger;
        this.bindProperties();
        this.ej2Instances._setProperties = this.ej2Instances.setProperties;
        this.ej2Instances.setProperties = this.setProperties;
        this.ej2Instances.clearTemplate = this.clearTemplate;
    }
    clearTemplate(templateNames) {
        if (!templateNames) {
            templateNames = Object.keys(this.templateCollection || {});
        }
        if (templateNames.length && this.templateCollection) {
            for (let tempName of templateNames) {
                let elementCollection = this.templateCollection[tempName];
                if (elementCollection && elementCollection.length) {
                    for (let ele of elementCollection) {
                        let destroy = getValue('__vue__.$destroy', ele);
                        if (destroy) {
                            ele.__vue__.$destroy();
                        }
                        if (ele.innerHTML) {
                            ele.innerHTML = '';
                        }
                    }
                    delete this.templateCollection[tempName];
                }
            }
        }
    }
    setProperties(prop, muteOnChange) {
        if (this.isVue3) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if (this.ej2Instances && this.ej2Instances._setProperties) {
            this.ej2Instances._setProperties(prop, muteOnChange);
        }
        if (prop && this.models && this.models.length) {
            Object.keys(prop).map((key) => {
                this.models.map((model) => {
                    if ((key === model) && !(/datasource/i.test(key))) {
                        if (this.isVue3) {
                            this.ej2Instances.vueInstance.$emit('update:' + key, prop[key]);
                        }
                        else {
                            this.$emit('update:' + key, prop[key]);
                            this.$emit('modelchanged', prop[key]);
                        }
                    }
                });
            });
        }
    }
    trigger(eventName, eventProp, successHandler) {
        if (!isExecute$5) {
            this.models = !this.models ? this.ej2Instances.referModels : this.models;
        }
        if ((eventName === 'change' || eventName === 'input') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/checked|value/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$5) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    if (eventName === 'change' || (this.$props && !this.$props.isLazyUpdate)) {
                        this.$emit('update:' + propKey, eventProp[propKey]);
                        this.$emit('modelchanged', eventProp[propKey]);
                    }
                }
            }
        }
        else if ((eventName === 'actionBegin' && eventProp.requestType === 'dateNavigate') && this.models && (this.models.length !== 0)) {
            let key = this.models.toString().match(/currentView|selectedDate/) || [];
            let propKey = key[0];
            if (eventProp && key && !isUndefined(eventProp[propKey])) {
                if (!isExecute$5) {
                    this.ej2Instances.vueInstance.$emit('update:' + propKey, eventProp[propKey]);
                    this.ej2Instances.vueInstance.$emit('modelchanged', eventProp[propKey]);
                }
                else {
                    this.$emit('update:' + propKey, eventProp[propKey]);
                    this.$emit('modelchanged', eventProp[propKey]);
                }
            }
        }
        if ((this.ej2Instances && this.ej2Instances._trigger)) {
            this.ej2Instances._trigger(eventName, eventProp, successHandler);
        }
    }
    render(createElement) {
        let h = gh || createElement;
        let slots = null;
        if (!isNullOrUndefined(this.$slots.default)) {
            slots = gh ? this.$slots.default() : this.$slots.default;
        }
        return h('input', slots);
    }
    clear() {
        return this.ej2Instances.clear();
    }
    ensureVisible(item) {
        return this.ej2Instances.ensureVisible(item);
    }
    getData(item) {
        return this.ej2Instances.getData(item);
    }
    getLocaleName() {
        return this.ej2Instances.getLocaleName();
    }
    hidePopup() {
        return this.ej2Instances.hidePopup();
    }
    selectAll(state) {
        return this.ej2Instances.selectAll(state);
    }
    showPopup() {
        return this.ej2Instances.showPopup();
    }
};
DropDownTreeComponent = __decorate$5([
    EJComponentDecorator({
        props: properties$5,
        model: {
            event: 'modelchanged'
        }
    }, isExecute$5)
    /* Start Options({
        props: props,
        watch: watch,
        emits: emitProbs
    }) End */
], DropDownTreeComponent);
const DropDownTreePlugin = {
    name: 'ejs-dropdowntree',
    install(Vue) {
        Vue.component(DropDownTreePlugin.name, DropDownTreeComponent);
    }
};

export { DropDownListComponent, DropDownListPlugin, ComboBoxComponent, ComboBoxPlugin, AutoCompleteComponent, AutoCompletePlugin, MultiSelectComponent, MultiSelectPlugin, ListBoxComponent, ListBoxPlugin, DropDownTreeComponent, DropDownTreePlugin };
export * from '@syncfusion/ej2-dropdowns';
//# sourceMappingURL=ej2-vue-dropdowns.es2015.js.map
