<?php
use App\Helpers;
?>
<html>
<head>
<meta charset="UTF-8">
<meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <!-- Latest compiled and minified JavaScript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css"  crossorigin="anonymous">

<link href="<?php echo e(env('APP_URL')); ?>/public/css/invoice.css" rel="stylesheet">
<link href="http://modocrm.com/css/invoice.css" rel="stylesheet">
<style>
    @media  screen {
        p.bodyText {font-family:verdana, arial, sans-serif;}
    }

    @media  print {
        .vendorListHeading {
            background-color: black !important;
            -webkit-print-color-adjust: exact;
        }
        .no-print {
            display: none;
        }

        .vendorListHeading th {
            color: white !important;
        }
        p.bodyText {font-family:georgia, times, serif;}
    }
    @media  screen, print {
        p.bodyText {font-size:10pt}
    }
    table td, table th {
        padding: 0.75rem;
        vertical-align: top;
        border-top: 0px solid #dee2e6 !important;
    }
</style>
</head>
<body>
<div class=" container" >
    <div class="row" >
        <div class="col-sm-12">
            <?php $__currentLoopData = $invoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoices): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="">
                <div class="panel-body">
                    <div class="row" style="width: 100%;display:inline-flex;height:18%">
                        <div class="col-sm-1 top-left from" style=" width:10%;float:left">
                            <div class="ribbon ribbon-top-left" >
                                <span>INVOICE</span>
                            </div>
                        </div>
                        <?php $__currentLoopData = $fromAddress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fromAddresses): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div style="width:40%;float:left">
                            <img src="<?php echo e(env('APP_URL')); ?>/storage/<?php echo e($fromAddresses->logo_file); ?>" class="pt-3" style="margin-left:10px;margin-top:10px;" width="230" height="60">
                         </div>
                            <div style="width:10%;float:right;height:50px;">
                                <button class="no-print " style="border:gray;background-color: crimson;color:white"  onclick="window.print()"> <a  class="btn btn-sm btn-white m-b-5 p-l-5"><i class="fa fa-print t-plus-1 fa-fw fa-lg"></i> Print</a></button>
                            </div>
                        <div class="text-right" style="width:40%;float:right">
                            <strong class=" text-110"><?php echo e($fromAddresses->legal_name); ?></strong>
                            <p > <?php echo e($fromAddresses->line_1); ?>,<br> <?php echo e($fromAddresses->line_2); ?></p>
                            <p><?php echo e($fromAddresses->city); ?>, <?php echo e($fromAddresses->state_name); ?> - <?php echo e($fromAddresses->zipcode); ?></p>
                            <?php if(isset($fromAddresses->gstin)): ?>
                                <p style="font-weight:600">GST # : <?php echo e($fromAddresses->gstin); ?></p>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <hr >
                    <div class="row" style="width: 100%;height:14%">

                        <div style="float:left;width:60%">
                        <?php $__currentLoopData = $toAddress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $toAddresses): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <strong class=""><?php echo e($toAddresses->legal_name); ?></strong>
                            <p><?php echo e($toAddresses->line_1); ?></p>
                            <p> <?php echo e($toAddresses->line_2); ?></p>
                            <p><?php echo e($toAddresses->landmark); ?> <?php echo e($toAddresses->city); ?></p>
                            <p><?php echo e($toAddresses->state_name); ?> - <?php echo e($toAddresses->zipcode); ?></p>
                            <?php if(isset($toAddresses->gstin)): ?>
                            <p>GST # : <span style="font-weight:600"> <?php echo e($toAddresses->gstin); ?></span></p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>


                        <div style="float:right;width:40%" >
                            <div style="text-align:left; float:left;width:40%" >
                                <p style="font-size: 18px ; font-weight: bold;">Invoice #</p>
                                <p>Invoice Date</p>
                                <p>Due Date</p>
                                <p>P.O #</p>
                            </div>
                            <div style="width:60%;float:right;text-align: right">
                                <p style="font-size: 18px ; font-weight: bold;"><?php echo e($invoices['prefix']); ?><?php echo e($invoices['invoice_number']); ?></p>
                                <p><?php echo e(Carbon\Carbon::parse($invoices->invoiced_at)->format('Y-m-d')); ?></p>
                                <p> <?php echo e(Carbon\Carbon::parse($invoices->due_at)->format('Y-m-d')); ?></p>
                                <p> <?php echo e(date('M  Y', strtotime($invoices->start_date))); ?> <?php if(isset($invoices->end_date)): ?> - <?php echo e(date('M  Y', strtotime($invoices->end_date))); ?> <?php endif; ?></p>
                            </div>
                        </div>

                    </div>

                    <div class="pt-4">
                        <table>
                            <thead style="">
                                <tr style="color: #eeeeee;background-color: black;">
                                    <th   class="text-center" style="width:4px !important;color:white !important;">#</th>
                                    <th style="width:55%">Item & Description</th>
                                    <th style="width:4%" class="text-center" >Qty</th>
                                    <th style="width:4%" class="text-center" >Price/HSN</th>
                                    <?php if($invoiceitem[0]['tax_id'] != null && $invoiceitem[0]['tax_name']=='GST'): ?>
                                    <th  class="text-center" style="width:9%">CGST</th>
                                    <th  class="text-center" style="width:9%">SGST</th>
                                    <?php endif; ?>
                                    <?php if($invoiceitem[0]['tax_id'] == null ): ?>
                                        <th class="text-center" style="width:7%">CGST</th>
                                        <th class="text-center" style="width:7%">SGST</th>
                                    <?php endif; ?>
                                    <?php if($invoiceitem[0]['tax_id'] != null && $invoiceitem[0]['tax_name']=='IGST'): ?>
                                    <th style="width:9%" class="text-center">IGST</th>
                                    <?php endif; ?>
                                    <th style="width:30%" class="text-center">Total (&#8377;)</th>
                                </tr>
                            </thead>
                            <tbody style="background-color: #eee">
                                <?php
                                $cgst   = 0;
                                $sgst   = 0;
                                ?>
                                <?php $__currentLoopData = $invoiceitem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoiceitems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="">
                                    <td  class="text-center border" style="width:4px !important;  "><?php echo e($loop->index+1); ?></td>
                                    <!-- <td></td> style="text-align: justify; text-justify: inter-word;"-->
                                    <td class="border" style="width:55%"><?php echo e($invoiceitems['name']); ?><p style="text-align: justify; text-justify: inter-word;" > <?php echo nl2br(e($invoiceitems['description'])); ?></p></td>
                                    <td class="text-center border" style="width:3%"><?php echo e($invoiceitems['quantity']); ?></td>
                                    <td class="text-center border" style="width:4%">&#8377;<?php echo e(formatCurrency($invoiceitems['price'])); ?>

                                        <p style="font-size: 12px;">(<?php echo e($invoiceitems['code']); ?>)<p>
                                    </td>
                                
                                    <?php if($invoiceitems['tax_id'] != null && $invoiceitems['tax_name']=='GST'): ?>
                                    <td style="width:9%" class="text-center border">₹<?php echo e(formatCurrency(($invoiceitems['price'] * ($invoiceitems['tax_id']/100))/2)); ?><br>(<?php echo e($invoiceitems['tax_id']/2); ?> %)</td>
                                    <td style="width:9%" class="text-center border">₹<?php echo e(formatCurrency(($invoiceitems['price'] * ($invoiceitems['tax_id']/100))/2)); ?><br>(<?php echo e($invoiceitems['tax_id']/2); ?> %)</td>
                                    <?php endif; ?>
                                
                                
                                    <?php if($invoiceitems['tax_id'] == null): ?>
                                        <td style="width:7%" class="text-center border">-</td>
                                        <td style="width:7%" class="text-center border">-</td>
                                    <?php endif; ?>
                                    <?php if($invoiceitems['tax_id'] != null && $invoiceitems['tax_name']=='IGST'): ?>
                                        <td style="width:9%" class="text-center border">&#8377;<?php echo e(formatCurrency(($invoiceitems['price'] * ($invoiceitems['tax_id']/100)))); ?></td>
                                    <?php endif; ?>
                                    <td style="width:30%" class="text-center border">₹ <?php echo e(formatCurrency($invoiceitems['total_amount'])); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot class="border">
                            <tr >
                                <td colspan="3" rowspan="4"><strong class="text-90">Notes </strong>  <p><?php echo $email[0]['notes']; ?></p></td>
                                <td class="border " colspan="2">SubTotal</td>
                                <td class="border text-right" colspan="2">&#x20B9; <?php echo e(formatCurrency($invoices['untaxed_amount'], '')); ?></td>
                            </tr>
                            <?php if(count($invoicetax) > 0): ?>


                                <?php $__currentLoopData = $invoicetax; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>

                                        <td class="border " colspan="2"><?php echo e($value['name']); ?> </td>
                                        <td class="border text-right" colspan="2">&#8377; <?php echo e(formatCurrency($value['amount'])); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php if($invoices['invoiceTaxAmount'] != 0): ?>
                                    <tr>

                                    <td class="border text-right" colspan="2">
                                        CGST (<?php echo e($invoiceitems['tax_id']/2); ?> %)
                                    </td>
                                    <td class="border text-right" colspan="2">
                                         &nbsp;&#8377; <?php echo e(formatCurrency($invoices['invoiceTaxAmount']/2)); ?>

                                    </td>
                                    </tr>
                                    <tr>

                                    <td class="border text-right" colspan="2">
                                        SGST (<?php echo e($invoiceitems['tax_id']/2); ?> %)
                                    </td>
                                    <td class="border text-right" colspan="2">
                                         &nbsp;&#8377; <?php echo e(formatCurrency($invoices['invoiceTaxAmount']/2)); ?>

                                    </td>
                                    </tr>
                                <?php endif; ?>

                            <?php endif; ?>
                                <?php if($invoices['discount_amount'] != 0): ?>
                                <tr>

                                    <td class="border " colspan="2"> Discount Amount</td>
                                    <td class="border text-right" colspan="2">&#8377; <?php echo e(formatCurrency($invoices['discount_amount'])); ?></td>
                                </tr>
                                <?php endif; ?>
                                <tr>

                                    <td class="border " colspan="2"> Total Amount</td>
                                    <td class="border text-right" colspan="2">&#8377; <?php echo e(formatCurrency($invoices['invoice_totalamount'])); ?></td>
                                </tr>
                        </tfoot>
                        </table>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <footer class="footer" style='width:100%;text-align:center;bottom:10px; position:fixed;height:2%;  color:#969BA7'>
        <hr />
        <span style="font-size: 12px">Powered By :</span>
        <span style='font-size:12px;color:red;margin:0px!important;' > onemodo.com</span>
    </footer>
</div>
</body>
</html>
<?php /**PATH /home/modocrm/public_html/fermi.modocrm.com/resources/views/invoice.blade.php ENDPATH**/ ?>