<?php
use App\Helpers\AppHelpers;
?>
    <!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css"  crossorigin="anonymous">
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="<?php echo e(env('APP_URL')); ?>/css/pdf.css" rel="stylesheet">


    <style>
        table > thead >tr >th {
            font-size : 14px !important;

        }
        table > tbody >tr >td {
            font-size : 13px !important;

        }
        @media  print {
            @page

            .no-print {
                visibility: hidden;
            }
            .table td, .table th {
                padding: 0px 3px !important;
            }
        }
    </style>
</head>
<body style=" page-break-after:always; ">
<div>
    <div class="row" style="">
        <div class="col-sm-4 px-2 py-2 ml-5">
            <?php if($entity[0]['logo_file']!=null): ?>
                <img src="<?php echo e(env('APP_URL')); ?>/storage/<?php echo e($entity[0]['logo_file']); ?>" class=""  style="width:100px;">
                <br><br>
                <span style="font-weight: bold;font-size: 18px;color:#27679b"><?php echo e($entity[0]['legal_name']); ?></span>
            <?php else: ?>
                <img src="../images/modoinfra_logo_v1-0.png" class="" width="200" height="80" style="">
            <?php endif; ?>
        </div>
        <div class="col-sm-5" >
            <h4 style="color:#27679b;font-weight: 600;margin-top:30px;margin-left:30px">LEDGER REPORT </h4>
            <i style="font-weight: bold;text-align:center;">Time Period:<?php echo e(Carbon\Carbon::parse($input['date'][0])->format('d-M-y')); ?> to <?php echo e(Carbon\Carbon::parse($input['date'][1])->format('d-M-y')); ?></i>
        </div>
        <div class="col-sm-1" >
            <button class="no-print " style="border:gray;background-color: crimson;color:white;margin-top:40px"  onclick="window.print()"> <a  class="btn btn-sm btn-white m-b-5 p-l-5"><i class="fa fa-print t-plus-1 fa-fw fa-lg"></i> Print</a></button>
        </div>
    </div>
    <?php $__currentLoopData = $opening_balance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op_key=>$op_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $opening =0; $ledger_name=''; ?>
        <?php $__currentLoopData = $op_value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $opening =$bal['opening_amount']; $ledger_name=$bal['title']; ?>


            
            <div class="col-md-12 pt-3">
                <table class="table " style="margin-bottom:0px !important">
                    <thead class="grouptable-bg border">
                    <tr class="bg text-dark" style="background-color: #27679b">
                        <th colspan="2" class="text-left " > Ledger Name : <b><?php echo e($ledger_name); ?></b></th>
                        <th colspan="2" class="text-right " >Opening Balance : &#8377; <?php echo e($opening >= 0 ? 'cr. '.AppHelpers::instance()->formatCurrency($opening) :  'dr. '.AppHelpers::instance()->formatCurrency(abs($opening))); ?> </th>
                    </tr>
                    </thead>
                </table>
                <div class="" >
                    <div class="table-responsive">

                        <table class="table table-invoice" style="">
                            <thead class="bg border" style="background-color: #dd4949">
                            <tr>
                                <th class="text-left pl-2 border">#</th>
                                
                                <th class="text-left pl-2 border" >DATE </th>
                                <th class="text-left pl-2 border">TYPE</th>
                                <th class="text-left pl-2 border">NOTES</th>
                                <th class="text-left pl-2 border">CREDIT (&#8377;)</th>
                                <th class="text-left pl-2 border">DEBIT (&#8377;)</th>
                            </tr>
                            </thead>
                            <tbody class="border">
                            <?php $debittotal=0;$credittotal=0; $balanceamount=0; $closing=0;?>
                            <?php if(!empty($sum_asset)): ?>
                                <?php $__currentLoopData = $sum_asset; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2=>$items2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $items2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1=>$items1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($ledger_name==$key2): ?>
                                            <tr>
                                                <?php
                                                    $debittotal += $items1['debit_amount'];
                                                    $credittotal += $items1['credit_amount'];
                                                    $balanceamount = $credittotal - $debittotal;
                                                ?>
                                                <td class="text-left pl-2 border"><?php echo e($loop->index+1); ?></td>
                                                <td class="text-left pl-2 border"><?php echo e(Carbon\Carbon::parse($items1['entry_date'])->format('d-m-Y')); ?></td>
                                                <td class="text-left pl-2 border"><?php echo e($items1['notes'] ? $items1['notes'] : ''); ?></td>
                                                <td class="text-left pl-2 border"><?php echo e($items1['narration']); ?></td>
                                                <td class="text-right pl-2 border"> <?php echo e($items1['credit_amount']>0 ? AppHelpers::instance()->formatCurrency($items1['credit_amount']) : '0'); ?></td>
                                                <td class="text-right pl-2 border"> <?php echo e($items1['debit_amount']>0 ? AppHelpers::instance()->formatCurrency($items1['debit_amount']) : '0'); ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                            <tfoot class="border">
                            <tr >
                                <th colspan="4" style="height:100px" class="text-right pl-2 border align-middle">Grand Total (&#8377;)</th>
                                <th colspan="1" style="height:100px" class="text-right pl-2 border align-middle"> <?php echo e($credittotal ? AppHelpers::instance()->formatCurrency($credittotal) : '0'); ?></th>
                                <th colspan="1" style="height:100px" class="text-right pl-2 border align-middle"> <?php echo e($debittotal ? AppHelpers::instance()->formatCurrency($debittotal) : '0'); ?></th>
                            </tr>
                            <tr style="height:100px">
                                <th colspan="4" style="height:100px" class="text-right pl-2 border align-middle">Closing Balance (&#8377;)</th>
                                <?php if(count($opening_balance) == 0): ?>
                                    <?php $openingbalance = 0; $closing=$balanceamount+$opening; ?>
                                <?php else: ?>
                                    <?php  $closing=$balanceamount+$opening; ?>
                                <?php endif; ?>
                                <th colspan="1" style="height:100px" class="text-right pl-2 border align-middle"> <?php echo e($closing > 0 ? AppHelpers::instance()->formatCurrency($closing) : '0'); ?></th>
                                <th colspan="1" style="height:100px" class="text-right pl-2 border align-middle"> <?php echo e($closing < 0 ? AppHelpers::instance()->formatCurrency(abs($closing)) : '0'); ?></th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
</div>
<footer class="footer " style='text-align:right; color:#969BA7;bottom:0px; position:fixed;'>

    <a style='font-size:12px; font-weight:600; '>Powered By:Modoinfra.com</a>
</footer>
</body>
</html>
<?php /**PATH /home/modocrm/public_html/fermi.modocrm.com/resources/views/Report/ledgerReport.blade.php ENDPATH**/ ?>